/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public final class ZKSplitLog {
    private static final Logger LOG = LoggerFactory.getLogger(ZKSplitLog.class);

    private ZKSplitLog() {
    }

    public static String getEncodedNodeName(ZKWatcher zkw, String filename) {
        return ZNodePaths.joinZNode((String)zkw.getZNodePaths().splitLogZNode, (String)ZKSplitLog.encode(filename));
    }

    public static String getFileName(String node) {
        String basename = node.substring(node.lastIndexOf(47) + 1);
        return ZKSplitLog.decode(basename);
    }

    static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLENCODER doesn't support UTF-8");
        }
    }

    static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLDecoder doesn't support UTF-8");
        }
    }

    public static String getRescanNode(ZKWatcher zkw) {
        return ZNodePaths.joinZNode((String)zkw.getZNodePaths().splitLogZNode, (String)"RESCAN");
    }

    public static boolean isRescanNode(String name) {
        return name.startsWith("RESCAN");
    }

    public static boolean isRescanNode(ZKWatcher zkw, String path) {
        String prefix = ZKSplitLog.getRescanNode(zkw);
        if (path.length() <= prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == path.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Path getSplitLogDir(Path rootdir, String tmpname) {
        return new Path(new Path(rootdir, "splitWAL"), tmpname);
    }

    public static void markCorrupted(Path rootdir, String logFileName, FileSystem fs) {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        try {
            fs.createNewFile(file);
        }
        catch (IOException e) {
            LOG.warn("Could not flag a log file as corrupted. Failed to create " + file, (Throwable)e);
        }
    }

    public static boolean isCorrupted(Path rootdir, String logFileName, FileSystem fs) throws IOException {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        boolean isCorrupt = fs.exists(file);
        return isCorrupt;
    }
}

