/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.LoadTestDataGeneratorWithMOB;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithMOB
extends IntegrationTestIngest {
    private static final char COLON = ':';
    private byte[] mobColumnFamily = HFileTestUtil.DEFAULT_COLUMN_FAMILY;
    public static final String THRESHOLD = "threshold";
    public static final String MIN_MOB_DATA_SIZE = "minMobDataSize";
    public static final String MAX_MOB_DATA_SIZE = "maxMobDataSize";
    private int threshold = 1024;
    private int minMobDataSize = 512;
    private int maxMobDataSize = this.threshold * 5;
    private static final long JUNIT_RUN_TIME = 120000L;
    protected String[] LOAD_TEST_TOOL_MOB_INIT_ARGS = new String[]{"compression", HFileTestUtil.OPT_DATA_BLOCK_ENCODING, "encryption", "num_regions_per_server", "region_replication"};

    @Override
    protected String[] getArgsForLoadTestToolInitTable() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-tn");
        args.add(this.getTablename().getNameAsString());
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        for (String arg : this.LOAD_TEST_TOOL_MOB_INIT_ARGS) {
            String val = this.conf.get(String.format("%s.%s", clazz, arg));
            if (val == null) continue;
            args.add("-" + arg);
            args.add(val);
        }
        args.add("-init_only");
        return args.toArray(new String[args.size()]);
    }

    @Override
    protected void addOptions() {
        super.addOptions();
        super.addOptWithArg(THRESHOLD, "The threshold to classify cells to mob data");
        super.addOptWithArg(MIN_MOB_DATA_SIZE, "Minimum value size for mob data");
        super.addOptWithArg(MAX_MOB_DATA_SIZE, "Maximum value size for mob data");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        if (cmd.hasOption(THRESHOLD)) {
            this.threshold = Integer.parseInt(cmd.getOptionValue(THRESHOLD));
        }
        if (cmd.hasOption(MIN_MOB_DATA_SIZE)) {
            this.minMobDataSize = Integer.parseInt(cmd.getOptionValue(MIN_MOB_DATA_SIZE));
        }
        if (cmd.hasOption(MAX_MOB_DATA_SIZE)) {
            this.maxMobDataSize = Integer.parseInt(cmd.getOptionValue(MAX_MOB_DATA_SIZE));
        }
        if (this.minMobDataSize > this.maxMobDataSize) {
            throw new IllegalArgumentException("The minMobDataSize should not be larger than minMobDataSize");
        }
    }

    @Override
    @Test
    public void testIngest() throws Exception {
        this.runIngestTest(120000L, 100L, 10, 1024, 10, 20);
    }

    @Override
    protected void initTable() throws IOException {
        super.initTable();
        TableName tableName = this.getTablename();
        try (Connection connection = ConnectionFactory.createConnection();
             Admin admin = connection.getAdmin();){
            HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
            LOG.info("Disabling table " + this.getTablename());
            admin.disableTable(tableName);
            ColumnFamilyDescriptor mobColumn = tableDesc.getColumnFamily(this.mobColumnFamily);
            ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)mobColumn).setMobEnabled(true).setMobThreshold((long)this.threshold).build();
            admin.modifyColumnFamily(tableName, cfd);
            LOG.info("Enabling table " + this.getTablename());
            admin.enableTable(tableName);
        }
    }

    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        String[] args = super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys);
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(args));
        tmp.add("-generator");
        StringBuilder sb = new StringBuilder(LoadTestDataGeneratorWithMOB.class.getName());
        sb.append(':');
        sb.append(Bytes.toString((byte[])this.mobColumnFamily));
        sb.append(':');
        sb.append(this.minMobDataSize);
        sb.append(':');
        sb.append(this.maxMobDataSize);
        tmp.add(sb.toString());
        return tmp.toArray(new String[tmp.size()]);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngestWithMOB(), (String[])args);
        System.exit(ret);
    }
}

