/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.junit.Assert;
import org.junit.Test;

public class TestMiniJournalCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStop() throws IOException {
        Configuration conf = new Configuration();
        MiniJournalCluster c = new MiniJournalCluster.Builder(conf).build();
        c.waitActive();
        try {
            URI uri = c.getQuorumJournalURI("myjournal");
            String[] addrs = uri.getAuthority().split(";");
            Assert.assertEquals((long)3L, (long)addrs.length);
            JournalNode node = c.getJournalNode(0);
            String dir = node.getConf().get("dfs.journalnode.edits.dir");
            Assert.assertEquals((Object)new File(MiniDFSCluster.getBaseDirectory() + "journalnode-0").getAbsolutePath(), (Object)dir);
        }
        finally {
            c.shutdown();
        }
    }
}

