/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFavoredNodesEndToEnd {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static final int NUM_DATA_NODES = 10;
    private static final int NUM_FILES = 10;
    private static final byte[] SOME_BYTES;
    private static DistributedFileSystem dfs;
    private static ArrayList<DataNode> datanodes;

    public TestFavoredNodesEndToEnd() {
        GenericTestUtils.setLogLevel((Log)LogFactory.getLog(BlockPlacementPolicy.class), (Level)Level.ALL);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(10).build();
        cluster.waitClusterUp();
        dfs = cluster.getFileSystem();
        datanodes = cluster.getDataNodes();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=180000L)
    public void testFavoredNodesEndToEnd() throws Exception {
        for (int i = 0; i < 10; ++i) {
            BlockLocation[] locations;
            Random rand = new Random(System.currentTimeMillis() + (long)i);
            InetSocketAddress[] datanode = this.getDatanodes(rand);
            Path p = new Path("/filename" + i);
            HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, datanode);
            out.write(SOME_BYTES);
            out.close();
            for (BlockLocation loc : locations = this.getBlockLocations(p)) {
                String[] hosts = loc.getNames();
                String[] hosts1 = this.getStringForInetSocketAddrs(datanode);
                Assert.assertTrue((boolean)this.compareNodes(hosts, hosts1));
            }
        }
    }

    @Test(timeout=180000L)
    public void testWhenFavoredNodesNotPresent() throws Exception {
        InetSocketAddress[] arbitraryAddrs = new InetSocketAddress[3];
        for (int i = 0; i < 3; ++i) {
            arbitraryAddrs[i] = this.getArbitraryLocalHostAddr();
        }
        Path p = new Path("/filename-foo-bar");
        HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, arbitraryAddrs);
        out.write(SOME_BYTES);
        out.close();
        this.getBlockLocations(p);
    }

    @Test(timeout=180000L)
    public void testWhenSomeNodesAreNotGood() throws Exception {
        InetSocketAddress[] addrs = new InetSocketAddress[4];
        String[] hosts = new String[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = datanodes.get(i).getXferAddress();
            hosts[i] = addrs[i].getAddress().getHostAddress() + ":" + addrs[i].getPort();
        }
        DatanodeDescriptor d = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanodeByXferAddr(addrs[0].getAddress().getHostAddress(), addrs[0].getPort());
        d.setDecommissioned();
        Path p = new Path("/filename-foo-bar-baz");
        int replication = 3;
        HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, addrs);
        out.write(SOME_BYTES);
        out.close();
        d.stopDecommission();
        BlockLocation[] locations = this.getBlockLocations(p);
        Assert.assertEquals((long)3L, (long)locations[0].getNames().length);
        for (int i = 0; i < 3; ++i) {
            int j;
            String loc = locations[0].getNames()[i];
            for (j = 0; j < hosts.length && !loc.equals(hosts[j]); ++j) {
            }
            Assert.assertTrue((String)("j=" + j), (j > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("loc=" + loc + " not in host list " + Arrays.asList(hosts) + ", j=" + j), (j < hosts.length ? 1 : 0) != 0);
        }
    }

    @Test(timeout=180000L)
    public void testFavoredNodesEndToEndForAppend() throws Exception {
        for (int i = 0; i < 10; ++i) {
            BlockLocation[] locations;
            Random rand = new Random(System.currentTimeMillis() + (long)i);
            InetSocketAddress[] datanode = this.getDatanodes(rand);
            Path p = new Path("/filename" + i);
            dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, null).close();
            FSDataOutputStream out = dfs.append(p, EnumSet.of(CreateFlag.APPEND), 4096, null, datanode);
            out.write(SOME_BYTES);
            out.close();
            for (BlockLocation loc : locations = this.getBlockLocations(p)) {
                String[] hosts = loc.getNames();
                String[] hosts1 = this.getStringForInetSocketAddrs(datanode);
                Assert.assertTrue((boolean)this.compareNodes(hosts, hosts1));
            }
        }
    }

    @Test(timeout=180000L)
    public void testCreateStreamBuilderFavoredNodesEndToEnd() throws Exception {
        for (int i = 0; i < 10; ++i) {
            BlockLocation[] locations;
            Random rand = new Random(System.currentTimeMillis() + (long)i);
            InetSocketAddress[] dns = this.getDatanodes(rand);
            Path p = new Path("/filename" + i);
            FSDataOutputStream out = dfs.createFile(p).favoredNodes(dns).build();
            out.write(SOME_BYTES);
            out.close();
            for (BlockLocation loc : locations = this.getBlockLocations(p)) {
                String[] hosts = loc.getNames();
                String[] hosts1 = this.getStringForInetSocketAddrs(dns);
                Assert.assertTrue((boolean)this.compareNodes(hosts, hosts1));
            }
        }
    }

    private BlockLocation[] getBlockLocations(Path p) throws Exception {
        DFSTestUtil.waitReplication((FileSystem)dfs, p, (short)3);
        BlockLocation[] locations = dfs.getClient().getBlockLocations(p.toUri().getPath(), 0L, Long.MAX_VALUE);
        Assert.assertTrue((locations.length == 1 && locations[0].getHosts().length == 3 ? 1 : 0) != 0);
        return locations;
    }

    private String[] getStringForInetSocketAddrs(InetSocketAddress[] datanode) {
        String[] strs = new String[datanode.length];
        for (int i = 0; i < datanode.length; ++i) {
            strs[i] = datanode[i].getAddress().getHostAddress() + ":" + datanode[i].getPort();
        }
        return strs;
    }

    private boolean compareNodes(String[] dnList1, String[] dnList2) {
        for (int i = 0; i < dnList1.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < dnList2.length; ++j) {
                if (!dnList1[i].equals(dnList2[j])) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            Assert.fail((String)(dnList1[i] + " not a favored node"));
        }
        return true;
    }

    private InetSocketAddress[] getDatanodes(Random rand) {
        int idx3;
        int idx2;
        int idx1 = rand.nextInt(10);
        while (idx1 == (idx2 = rand.nextInt(10))) {
        }
        while (idx2 == (idx3 = rand.nextInt(10)) || idx1 == idx3) {
        }
        InetSocketAddress[] addrs = new InetSocketAddress[]{datanodes.get(idx1).getXferAddress(), datanodes.get(idx2).getXferAddress(), datanodes.get(idx3).getXferAddress()};
        return addrs;
    }

    private InetSocketAddress getArbitraryLocalHostAddr() throws UnknownHostException {
        boolean conflict;
        Random rand = new Random(System.currentTimeMillis());
        int port = rand.nextInt(65535);
        do {
            conflict = false;
            for (DataNode d : datanodes) {
                if (d.getXferAddress().getPort() != port) continue;
                port = rand.nextInt(65535);
                conflict = true;
            }
        } while (conflict);
        return new InetSocketAddress(InetAddress.getLocalHost(), port);
    }

    static {
        SOME_BYTES = new String("foo").getBytes();
    }
}

