/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuResourcePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePluginManager.class);
    private static final Set<String> SUPPORTED_RESOURCE_PLUGINS = ImmutableSet.of((Object)"yarn.io/gpu");
    private Map<String, ResourcePlugin> configuredPlugins = Collections.EMPTY_MAP;

    public synchronized void initialize(Context context) throws YarnException {
        Configuration conf = context.getConf();
        String[] plugins = conf.getStrings("yarn.nodemanager.resource-plugins");
        if (plugins != null) {
            HashMap<String, GpuResourcePlugin> pluginMap = new HashMap<String, GpuResourcePlugin>();
            for (String resourceName : plugins) {
                if (!SUPPORTED_RESOURCE_PLUGINS.contains(resourceName = resourceName.trim())) {
                    String msg = "Trying to initialize resource plugin with name=" + resourceName + ", it is not supported, list of supported plugins:" + StringUtils.join((Object[])new Object[]{",", SUPPORTED_RESOURCE_PLUGINS});
                    LOG.error(msg);
                    throw new YarnException(msg);
                }
                if (pluginMap.containsKey(resourceName)) continue;
                GpuResourcePlugin plugin = null;
                if (resourceName.equals("yarn.io/gpu")) {
                    plugin = new GpuResourcePlugin();
                }
                if (plugin == null) {
                    throw new YarnException("This shouldn't happen, plugin=" + resourceName + " should be loaded and initialized");
                }
                plugin.initialize(context);
                pluginMap.put(resourceName, plugin);
            }
            this.configuredPlugins = Collections.unmodifiableMap(pluginMap);
        }
    }

    public synchronized void cleanup() throws YarnException {
        for (ResourcePlugin plugin : this.configuredPlugins.values()) {
            plugin.cleanup();
        }
    }

    public synchronized Map<String, ResourcePlugin> getNameToPlugins() {
        return this.configuredPlugins;
    }
}

