/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.rest.ExistsResource;
import org.apache.hadoop.hbase.rest.MultiRowResource;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RegionsResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowResource;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.SchemaResource;
import org.apache.hadoop.hbase.rest.TableScanResource;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.javax.ws.rs.DefaultValue;
import org.apache.hbase.thirdparty.javax.ws.rs.Encoded;
import org.apache.hbase.thirdparty.javax.ws.rs.HeaderParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.QueryParam;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableResource
extends ResourceBase {
    String table;
    private static final Logger LOG = LoggerFactory.getLogger(TableResource.class);
    private static final Base64.Decoder base64Urldecoder = Base64.getUrlDecoder();

    public TableResource(String table) throws IOException {
        this.table = table;
    }

    String getName() {
        return this.table;
    }

    boolean exists() throws IOException {
        return this.servlet.getAdmin().tableExists(TableName.valueOf((String)this.table));
    }

    @Path(value="exists")
    public ExistsResource getExistsResource() throws IOException {
        return new ExistsResource(this);
    }

    @Path(value="regions")
    public RegionsResource getRegionsResource() throws IOException {
        return new RegionsResource(this);
    }

    @Path(value="scanner")
    public ScannerResource getScannerResource() throws IOException {
        return new ScannerResource(this);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() throws IOException {
        return new SchemaResource(this);
    }

    @Path(value="{multiget: multiget.*}")
    public MultiRowResource getMultipleRowResource(@QueryParam(value="v") String versions, @PathParam(value="multiget") String path) throws IOException {
        return new MultiRowResource(this, versions, path.replace("multiget", "").replace("/", ""));
    }

    @Path(value="{rowspec: [^*]+}")
    public RowResource getRowResource(@PathParam(value="rowspec") @Encoded String rowspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check, @QueryParam(value="rr") String returnResult, @HeaderParam(value="Encoding") String keyEncodingHeader, @QueryParam(value="e") String keyEncodingQuery) throws IOException {
        String keyEncoding = keyEncodingHeader != null ? keyEncodingHeader : keyEncodingQuery;
        return new RowResource(this, rowspec, versions, check, returnResult, keyEncoding);
    }

    @Path(value="{suffixglobbingspec: .*\\*/.+}")
    public RowResource getRowResourceWithSuffixGlobbing(@PathParam(value="suffixglobbingspec") @Encoded String suffixglobbingspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check, @QueryParam(value="rr") String returnResult, @HeaderParam(value="Encoding") String keyEncodingHeader, @QueryParam(value="e") String keyEncodingQuery) throws IOException {
        String keyEncoding = keyEncodingHeader != null ? keyEncodingHeader : keyEncodingQuery;
        return new RowResource(this, suffixglobbingspec, versions, check, returnResult, keyEncoding);
    }

    @Path(value="{scanspec: .*[*]$}")
    public TableScanResource getScanResource(@PathParam(value="scanspec") String scanSpec, @DefaultValue(value="2147483647") @QueryParam(value="limit") int userRequestedLimit, @DefaultValue(value="") @QueryParam(value="startrow") String startRow, @DefaultValue(value="") @QueryParam(value="endrow") String endRow, @QueryParam(value="column") List<String> column, @DefaultValue(value="1") @QueryParam(value="maxversions") int maxVersions, @DefaultValue(value="-1") @QueryParam(value="batchsize") int batchSize, @DefaultValue(value="0") @QueryParam(value="starttime") long startTime, @DefaultValue(value="9223372036854775807") @QueryParam(value="endtime") long endTime, @DefaultValue(value="true") @QueryParam(value="cacheblocks") boolean cacheBlocks, @DefaultValue(value="false") @QueryParam(value="reversed") boolean reversed, @QueryParam(value="filter") String paramFilter, @QueryParam(value="filter_b64") @Encoded String paramFilterB64, @DefaultValue(value="true") @QueryParam(value="includeStartRow") boolean includeStartRow, @DefaultValue(value="false") @QueryParam(value="includeStopRow") boolean includeStopRow) {
        try {
            ParseFilter pf;
            Filter parsedParamFilter;
            Object prefixBytes;
            PrefixFilter prefixFilter = null;
            Scan tableScan = new Scan();
            if (scanSpec.indexOf(42) > 0) {
                String prefix = scanSpec.substring(0, scanSpec.indexOf(42));
                prefixBytes = Bytes.toBytes((String)prefix);
                prefixFilter = new PrefixFilter(Bytes.toBytes((String)prefix));
                if (startRow.isEmpty()) {
                    tableScan.withStartRow((byte[])prefixBytes, includeStartRow);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Query parameters  : Table Name = > " + this.table + " Start Row => " + startRow + " End Row => " + endRow + " Columns => " + column + " Start Time => " + startTime + " End Time => " + endTime + " Cache Blocks => " + cacheBlocks + " Max Versions => " + maxVersions + " Batch Size => " + batchSize);
            }
            Table hTable = RESTServlet.getInstance().getTable(this.table);
            tableScan.setBatch(batchSize);
            tableScan.setMaxVersions(maxVersions);
            tableScan.setTimeRange(startTime, endTime);
            if (!startRow.isEmpty()) {
                tableScan.withStartRow(Bytes.toBytes((String)startRow), includeStartRow);
            }
            tableScan.withStopRow(Bytes.toBytes((String)endRow), includeStopRow);
            prefixBytes = column.iterator();
            while (prefixBytes.hasNext()) {
                String col = (String)prefixBytes.next();
                byte[][] parts = CellUtil.parseColumn((byte[])Bytes.toBytes((String)col.trim()));
                if (parts.length == 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Scan family : " + Bytes.toStringBinary((byte[])parts[0]));
                    }
                    tableScan.addFamily(parts[0]);
                    continue;
                }
                if (parts.length == 2) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Scan family and column : " + Bytes.toStringBinary((byte[])parts[0]) + "  " + Bytes.toStringBinary((byte[])parts[1]));
                    }
                    tableScan.addColumn(parts[0], parts[1]);
                    continue;
                }
                throw new IllegalArgumentException("Invalid column specifier.");
            }
            FilterList filterList = new FilterList(new Filter[0]);
            byte[] filterBytes = null;
            if (paramFilterB64 != null) {
                filterBytes = base64Urldecoder.decode(paramFilterB64);
            } else if (paramFilter != null) {
                filterBytes = paramFilter.getBytes();
            }
            if (filterBytes != null && (parsedParamFilter = (pf = new ParseFilter()).parseFilterString(filterBytes)) != null) {
                filterList.addFilter(parsedParamFilter);
            }
            if (prefixFilter != null) {
                filterList.addFilter((Filter)prefixFilter);
            }
            if (filterList.size() > 0) {
                tableScan.setFilter((Filter)filterList);
            }
            int fetchSize = this.servlet.getConfiguration().getInt("hbase.rest.scan.fetchsize", 10);
            tableScan.setCaching(fetchSize);
            tableScan.setReversed(reversed);
            tableScan.setCacheBlocks(cacheBlocks);
            return new TableScanResource(hTable.getScanner(tableScan), userRequestedLimit);
        }
        catch (IOException exp) {
            this.servlet.getMetrics().incrementFailedScanRequests(1);
            this.processException(exp);
            LOG.warn(exp.toString(), (Throwable)exp);
            return null;
        }
    }
}

