/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class InnerStoreCellComparator
extends CellComparatorImpl {
    private static final long serialVersionUID = 8186411895799094989L;
    public static final InnerStoreCellComparator INNER_STORE_COMPARATOR = new InnerStoreCellComparator();

    @Override
    protected int compareFamilies(Cell left, int leftFamilyLength, Cell right, int rightFamilyLength) {
        return leftFamilyLength - rightFamilyLength;
    }

    @Override
    protected int compareFamilies(KeyValue left, int leftFamilyPosition, int leftFamilyLength, KeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return leftFamilyLength - rightFamilyLength;
    }

    @Override
    protected int compareFamilies(ByteBufferKeyValue left, int leftFamilyPosition, int leftFamilyLength, ByteBufferKeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return leftFamilyLength - rightFamilyLength;
    }

    @Override
    protected int compareFamilies(KeyValue left, int leftFamilyPosition, int leftFamilyLength, ByteBufferKeyValue right, int rightFamilyPosition, int rightFamilyLength) {
        return leftFamilyLength - rightFamilyLength;
    }

    public static CellComparator getInnerStoreCellComparator(TableName tableName) {
        return InnerStoreCellComparator.getInnerStoreCellComparator(tableName.toBytes());
    }

    public static CellComparator getInnerStoreCellComparator(byte[] tableName) {
        return Bytes.equals(tableName, TableName.META_TABLE_NAME.toBytes()) ? MetaCellComparator.META_COMPARATOR : INNER_STORE_COMPARATOR;
    }
}

