/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.CloseRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.OpenRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionRemoteProcedureBase;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TransitRegionStateProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.RegionStateTransitionState> {
    private static final Logger LOG = LoggerFactory.getLogger(TransitRegionStateProcedure.class);
    private TransitionType type;
    private MasterProcedureProtos.RegionStateTransitionState initialState;
    private MasterProcedureProtos.RegionStateTransitionState lastState;
    private ServerName assignCandidate;
    private boolean forceNewPlan;
    private RetryCounter retryCounter;
    private RegionRemoteProcedureBase remoteProc;
    private boolean evictCache;
    private boolean isSplit;
    private RetryCounter forceRetainmentRetryCounter;
    private long forceRetainmentTotalWait;

    public TransitRegionStateProcedure() {
    }

    private void setInitialAndLastState() {
        switch (this.type) {
            case ASSIGN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED;
                break;
            }
            case UNASSIGN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED;
                break;
            }
            case MOVE: 
            case REOPEN: {
                this.initialState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE;
                this.lastState = MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown TransitionType: " + (Object)((Object)this.type));
            }
        }
    }

    protected TransitRegionStateProcedure(MasterProcedureEnv env, RegionInfo hri, ServerName assignCandidate, boolean forceNewPlan, TransitionType type) {
        super(env, hri);
        this.assignCandidate = assignCandidate;
        this.forceNewPlan = forceNewPlan;
        this.type = type;
        this.setInitialAndLastState();
        if (type == TransitionType.REOPEN) {
            this.assignCandidate = this.getRegionStateNode(env).getRegionLocation();
        }
        this.evictCache = env.getMasterConfiguration().getBoolean("hbase.rs.evictblocksonclose", false);
        this.initForceRetainmentRetryCounter(env);
    }

    private void initForceRetainmentRetryCounter(MasterProcedureEnv env) {
        if (env.getAssignmentManager().isForceRegionRetainment()) {
            this.forceRetainmentRetryCounter = new RetryCounter(env.getAssignmentManager().getForceRegionRetainmentRetries(), env.getAssignmentManager().getForceRegionRetainmentWaitInterval(), TimeUnit.MILLISECONDS);
            this.forceRetainmentTotalWait = 0L;
        }
    }

    protected TransitRegionStateProcedure(MasterProcedureEnv env, RegionInfo hri, ServerName assignCandidate, boolean forceNewPlan, TransitionType type, boolean isSplit) {
        this(env, hri, assignCandidate, forceNewPlan, type);
        this.isSplit = isSplit;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        if (TableName.isMetaTableName(this.getTableName())) {
            return false;
        }
        AssignmentManager am = env.getAssignmentManager();
        return am.waitMetaLoaded(this) || am.waitMetaAssigned(this, this.getRegion());
    }

    private void checkAndWaitForOriginalServer(MasterProcedureEnv env, ServerName lastHost) throws ProcedureSuspendedException {
        ServerManager serverManager = env.getMasterServices().getServerManager();
        ServerName newNameForServer = serverManager.findServerWithSameHostnamePortWithLock(lastHost);
        boolean isOnline = serverManager.createDestinationServersList().contains(newNameForServer);
        if (!isOnline && this.forceRetainmentRetryCounter.shouldRetry()) {
            int backoff = Math.toIntExact(this.forceRetainmentRetryCounter.getBackoffTimeAndIncrementAttempts());
            this.forceRetainmentTotalWait += (long)backoff;
            LOG.info("Suspending the TRSP PID={} for {}ms because {} is true and previous host {} for region is not yet online.", new Object[]{this.getProcId(), backoff, "hbase.master.scp.retain.assignment.force", lastHost});
            this.setTimeout(backoff);
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            throw new ProcedureSuspendedException();
        }
        LOG.info("{} is true. TRSP PID={} waited {}ms for host {} to come back online. Did host come back online? {}", new Object[]{"hbase.master.scp.retain.assignment.force", this.getProcId(), this.forceRetainmentTotalWait, lastHost, isOnline});
        this.initForceRetainmentRetryCounter(env);
    }

    private void queueAssign(MasterProcedureEnv env, RegionStateNode regionNode) throws ProcedureSuspendedException {
        boolean retain = false;
        if (this.forceNewPlan) {
            regionNode.setRegionLocation(null);
        } else {
            if (this.assignCandidate != null) {
                retain = this.assignCandidate.equals(regionNode.getLastHost());
                regionNode.setRegionLocation(this.assignCandidate);
            } else if (regionNode.getLastHost() != null) {
                retain = true;
                LOG.info("Setting lastHost {} as the location for region {}", (Object)regionNode.getLastHost(), (Object)regionNode.getRegionInfo().getEncodedName());
                regionNode.setRegionLocation(regionNode.getLastHost());
            }
            if (regionNode.getRegionLocation() != null && env.getAssignmentManager().isForceRegionRetainment()) {
                LOG.warn("{} is set to true. This may delay regions re-assignment upon RegionServers crashes or restarts.", (Object)"hbase.master.scp.retain.assignment.force");
                this.checkAndWaitForOriginalServer(env, regionNode.getRegionLocation());
            }
        }
        LOG.info("Starting {}; {}; forceNewPlan={}, retain={}", new Object[]{this, regionNode.toShortString(), this.forceNewPlan, retain});
        env.getAssignmentManager().queueAssign(regionNode);
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_OPEN);
        if (regionNode.getProcedureEvent().suspendIfNotReady(this)) {
            throw new ProcedureSuspendedException();
        }
    }

    private void openRegion(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        ServerName loc = regionNode.getRegionLocation();
        if (loc == null || LoadBalancer.BOGUS_SERVER_NAME.equals(loc)) {
            LOG.warn("No location specified for {}, jump back to state {} to get one", (Object)this.getRegion(), (Object)MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            throw new HBaseIOException("Failed to open region, the location is null or bogus.");
        }
        env.getAssignmentManager().regionOpening(regionNode);
        this.addChildProcedure(new OpenRegionProcedure[]{new OpenRegionProcedure(this, this.getRegion(), loc)});
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED);
    }

    private StateMachineProcedure.Flow confirmOpened(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.OPEN)) {
            this.retryCounter = null;
            if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_OPENED) {
                regionNode.unsetProcedure(this);
                ServerCrashProcedure.updateProgress(env, this.getParentProcId());
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        int retries = env.getAssignmentManager().getRegionStates().addToFailedOpen(regionNode).incrementAndGetRetries();
        int maxAttempts = env.getAssignmentManager().getAssignMaxAttempts();
        LOG.info("Retry={} of max={}; {}; {}", new Object[]{retries, maxAttempts, this, regionNode.toShortString()});
        if (retries >= maxAttempts) {
            env.getAssignmentManager().regionFailedOpen(regionNode, true);
            this.setFailure(this.getClass().getSimpleName(), new RetriesExhaustedException("Max attempts " + env.getAssignmentManager().getAssignMaxAttempts() + " exceeded"));
            regionNode.unsetProcedure(this);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        env.getAssignmentManager().regionFailedOpen(regionNode, false);
        this.forceNewPlan = true;
        regionNode.setRegionLocation(null);
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        if (retries > env.getAssignmentManager().getAssignRetryImmediatelyMaxAttempts()) {
            throw new HBaseIOException("Failed confirm OPEN of " + regionNode + " (remote log may yield more detail on why).");
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void closeRegion(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.OPEN, RegionState.State.CLOSING, RegionState.State.MERGING, RegionState.State.SPLITTING)) {
            env.getAssignmentManager().regionClosing(regionNode);
            CloseRegionProcedure closeProc = this.isSplit ? new CloseRegionProcedure(this, this.getRegion(), regionNode.getRegionLocation(), this.assignCandidate, env.getMasterConfiguration().getBoolean("hbase.rs.evictblocksonsplit", true)) : new CloseRegionProcedure(this, this.getRegion(), regionNode.getRegionLocation(), this.assignCandidate, this.evictCache);
            this.addChildProcedure(new CloseRegionProcedure[]{closeProc});
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED);
        } else {
            this.forceNewPlan = true;
            regionNode.setRegionLocation(null);
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        }
    }

    private StateMachineProcedure.Flow confirmClosed(MasterProcedureEnv env, RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.CLOSED)) {
            this.retryCounter = null;
            if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
                regionNode.unsetProcedure(this);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        if (regionNode.isInState(RegionState.State.CLOSING)) {
            this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CLOSE);
            throw new HBaseIOException("Failed to close region");
        }
        assert (regionNode.isInState(RegionState.State.ABNORMALLY_CLOSED));
        if (!RegionReplicaUtil.isDefaultReplica(this.getRegion()) && this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
            regionNode.unsetProcedure(this);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        this.retryCounter = null;
        this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void beforeExec(MasterProcedureEnv env) {
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
        regionNode.lock();
    }

    @Override
    protected void afterExec(MasterProcedureEnv env) {
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
        regionNode.unlock();
    }

    private RegionStateNode getRegionStateNode(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RegionStateTransitionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        RegionStateNode regionNode = this.getRegionStateNode(env);
        try {
            switch (state) {
                case REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE: {
                    if (!RegionReplicaUtil.isDefaultReplica(regionNode.getRegionInfo())) {
                        RegionInfo defaultRI = RegionReplicaUtil.getRegionInfoForDefaultReplica(regionNode.getRegionInfo());
                        if (env.getMasterServices().getAssignmentManager().getRegionStates().getRegionStateNode(defaultRI) == null) {
                            LOG.error("Cannot assign replica region {} because its primary region {} does not exist.", (Object)regionNode.getRegionInfo(), (Object)defaultRI);
                            regionNode.unsetProcedure(this);
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                    }
                    this.queueAssign(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_OPEN: {
                    this.openRegion(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_CONFIRM_OPENED: {
                    return this.confirmOpened(env, regionNode);
                }
                case REGION_STATE_TRANSITION_CLOSE: {
                    this.closeRegion(env, regionNode);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_CONFIRM_CLOSED: {
                    return this.confirmClosed(env, regionNode);
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (IOException e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed transition, suspend {}secs {}; {}; waiting on rectified condition fixed by other Procedure or operator intervention", new Object[]{backoff / 1000L, this, regionNode.toShortString(), e});
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    public void reportTransition(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId, long procId) throws IOException {
        if (this.remoteProc == null) {
            LOG.warn("There is no outstanding remote region procedure for {}, serverName={}, code={}, seqId={}, proc={}, should be a retry, ignore", new Object[]{regionNode, serverName, code, seqId, this});
            return;
        }
        if (procId >= 0L && this.remoteProc.getProcId() != procId) {
            LOG.warn("The pid of remote region procedure for {} is {}, the reported pid={}, serverName={}, code={}, seqId={}, proc={}, should be a retry, ignore", new Object[]{regionNode, this.remoteProc.getProcId(), procId, serverName, code, seqId, this});
            return;
        }
        this.remoteProc.reportTransition(env, regionNode, serverName, code, seqId);
    }

    public void serverCrashed(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName, boolean forceNewPlan) throws IOException {
        this.forceNewPlan = forceNewPlan;
        if (this.remoteProc != null) {
            this.remoteProc.serverCrashed(env, regionNode, serverName);
        } else {
            env.getAssignmentManager().regionClosedAbnormally(regionNode);
        }
    }

    void attachRemoteProc(RegionRemoteProcedureBase proc) {
        this.remoteProc = proc;
    }

    void unattachRemoteProc(RegionRemoteProcedureBase proc) {
        assert (this.remoteProc == proc);
        this.remoteProc = null;
    }

    void stateLoaded(AssignmentManager am, RegionStateNode regionNode) {
        if (this.remoteProc != null) {
            this.remoteProc.stateLoaded(am, regionNode);
        }
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.RegionStateTransitionState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MasterProcedureProtos.RegionStateTransitionState getState(int stateId) {
        return MasterProcedureProtos.RegionStateTransitionState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.RegionStateTransitionState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.RegionStateTransitionState getInitialState() {
        return this.initialState;
    }

    private static TransitionType convert(MasterProcedureProtos.RegionTransitionType type) {
        switch (type) {
            case ASSIGN: {
                return TransitionType.ASSIGN;
            }
            case UNASSIGN: {
                return TransitionType.UNASSIGN;
            }
            case MOVE: {
                return TransitionType.MOVE;
            }
            case REOPEN: {
                return TransitionType.REOPEN;
            }
        }
        throw new IllegalArgumentException("Unknown RegionTransitionType: " + type);
    }

    private static MasterProcedureProtos.RegionTransitionType convert(TransitionType type) {
        switch (type) {
            case ASSIGN: {
                return MasterProcedureProtos.RegionTransitionType.ASSIGN;
            }
            case UNASSIGN: {
                return MasterProcedureProtos.RegionTransitionType.UNASSIGN;
            }
            case MOVE: {
                return MasterProcedureProtos.RegionTransitionType.MOVE;
            }
            case REOPEN: {
                return MasterProcedureProtos.RegionTransitionType.REOPEN;
            }
        }
        throw new IllegalArgumentException("Unknown TransitionType: " + (Object)((Object)type));
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RegionStateTransitionStateData.Builder builder = MasterProcedureProtos.RegionStateTransitionStateData.newBuilder().setType(TransitRegionStateProcedure.convert(this.type)).setForceNewPlan(this.forceNewPlan).setEvictCache(this.evictCache).setIsSplit(this.isSplit);
        if (this.assignCandidate != null) {
            builder.setAssignCandidate(ProtobufUtil.toServerName(this.assignCandidate));
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RegionStateTransitionStateData data = serializer.deserialize(MasterProcedureProtos.RegionStateTransitionStateData.class);
        this.type = TransitRegionStateProcedure.convert(data.getType());
        this.setInitialAndLastState();
        this.forceNewPlan = data.getForceNewPlan();
        if (data.hasAssignCandidate()) {
            this.assignCandidate = ProtobufUtil.toServerName(data.getAssignCandidate());
        }
        this.evictCache = data.getEvictCache();
        this.isSplit = data.getIsSplit();
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        MetricsAssignmentManager metrics = env.getAssignmentManager().getAssignmentManagerMetrics();
        switch (this.type) {
            case ASSIGN: {
                return metrics.getAssignProcMetrics();
            }
            case UNASSIGN: {
                return metrics.getUnassignProcMetrics();
            }
            case MOVE: {
                return metrics.getMoveProcMetrics();
            }
            case REOPEN: {
                return metrics.getReopenProcMetrics();
            }
        }
        throw new IllegalArgumentException("Unknown transition type: " + (Object)((Object)this.type));
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        if (this.initialState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE) {
            sb.append(", ASSIGN");
        } else if (this.lastState == MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_CONFIRM_CLOSED) {
            sb.append(", UNASSIGN");
        } else {
            sb.append(", REOPEN/MOVE");
        }
    }

    private static TransitRegionStateProcedure setOwner(MasterProcedureEnv env, TransitRegionStateProcedure proc) {
        proc.setOwner(env.getRequestUser().getShortName());
        return proc;
    }

    public static TransitRegionStateProcedure assign(MasterProcedureEnv env, RegionInfo region, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.assign(env, region, false, targetServer);
    }

    public static TransitRegionStateProcedure assign(MasterProcedureEnv env, RegionInfo region, boolean forceNewPlan, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, targetServer, forceNewPlan, TransitionType.ASSIGN));
    }

    public static TransitRegionStateProcedure unassign(MasterProcedureEnv env, RegionInfo region) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, null, false, TransitionType.UNASSIGN));
    }

    public static TransitRegionStateProcedure unassignSplitMerge(MasterProcedureEnv env, RegionInfo region) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, null, false, TransitionType.UNASSIGN, true));
    }

    public static TransitRegionStateProcedure reopen(MasterProcedureEnv env, RegionInfo region) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, null, false, TransitionType.REOPEN));
    }

    public static TransitRegionStateProcedure move(MasterProcedureEnv env, RegionInfo region, @Nullable ServerName targetServer) {
        return TransitRegionStateProcedure.setOwner(env, new TransitRegionStateProcedure(env, region, targetServer, targetServer == null, TransitionType.MOVE));
    }

    public static enum TransitionType {
        ASSIGN,
        UNASSIGN,
        MOVE,
        REOPEN;

    }
}

