/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnCount;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.NewVersionBehaviorTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityNewVersionBehaivorTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityScanDeleteTracker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ScanQueryMatcher
implements ShipperListener {
    protected final CellComparator rowComparator;
    protected final Cell startKey;
    protected final ColumnTracker columns;
    protected final long oldestUnexpiredTS;
    protected final long now;
    protected Cell currentRow;

    protected ScanQueryMatcher(Cell startKey, ScanInfo scanInfo, ColumnTracker columns, long oldestUnexpiredTS, long now) {
        this.rowComparator = scanInfo.getComparator();
        this.startKey = startKey;
        this.oldestUnexpiredTS = oldestUnexpiredTS;
        this.now = now;
        this.columns = columns;
    }

    private static boolean isCellTTLExpired(Cell cell, long oldestTimestamp, long now) {
        Iterator<Tag> i = PrivateCellUtil.tagsIterator(cell);
        while (i.hasNext()) {
            Tag t = i.next();
            if (8 != t.getType()) continue;
            long ts = cell.getTimestamp();
            assert (t.getValueLength() == 8);
            long ttl = Tag.getValueAsLong(t);
            if (ts + ttl >= now) break;
            return true;
        }
        return false;
    }

    protected final MatchCode preCheck(Cell cell) {
        if (this.currentRow == null) {
            return MatchCode.DONE;
        }
        if (this.rowComparator.compareRows(this.currentRow, cell) != 0) {
            return MatchCode.DONE;
        }
        if (this.columns.done()) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        long timestamp = cell.getTimestamp();
        if (timestamp == Long.MIN_VALUE || this.columns.isDone(timestamp)) {
            return this.columns.getNextRowOrNextColumn(cell);
        }
        if (ScanQueryMatcher.isCellTTLExpired(cell, this.oldestUnexpiredTS, this.now)) {
            return MatchCode.SKIP;
        }
        return null;
    }

    protected final MatchCode checkDeleted(DeleteTracker deletes, Cell cell) {
        if (deletes.isEmpty() && !(deletes instanceof NewVersionBehaviorTracker)) {
            return null;
        }
        DeleteTracker.DeleteResult deleteResult = deletes.isDeleted(cell);
        switch (deleteResult) {
            case FAMILY_DELETED: 
            case COLUMN_DELETED: {
                if (!(deletes instanceof NewVersionBehaviorTracker)) {
                    return this.columns.getNextRowOrNextColumn(cell);
                }
            }
            case VERSION_DELETED: 
            case FAMILY_VERSION_DELETED: 
            case VERSION_MASKED: {
                return MatchCode.SKIP;
            }
            case NOT_DELETED: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected delete result: " + (Object)((Object)deleteResult));
    }

    public abstract MatchCode match(Cell var1) throws IOException;

    public Cell getStartKey() {
        return this.startKey;
    }

    public abstract boolean hasNullColumnInQuery();

    public Cell currentRow() {
        return this.currentRow;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
    }

    protected abstract void reset();

    public void setToNewRow(Cell currentRow) {
        this.currentRow = currentRow;
        this.columns.reset();
        this.reset();
    }

    public abstract boolean isUserScan();

    public abstract boolean moreRowsMayExistAfter(Cell var1);

    public Cell getKeyForNextColumn(Cell cell) {
        Cell nextKey;
        if (cell.getQualifierLength() == 0 && (nextKey = PrivateCellUtil.createNextOnRowCol(cell)) != cell) {
            return nextKey;
        }
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return PrivateCellUtil.createLastOnRowCol(cell);
        }
        return PrivateCellUtil.createFirstOnRowCol(cell, nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength());
    }

    public int compareKeyForNextRow(Cell nextIndexed, Cell currentCell) {
        return PrivateCellUtil.compareKeyBasedOnColHint(this.rowComparator, nextIndexed, currentCell, 0, 0, null, 0, 0, Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
    }

    public int compareKeyForNextColumn(Cell nextIndexed, Cell currentCell) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return PrivateCellUtil.compareKeyBasedOnColHint(this.rowComparator, nextIndexed, currentCell, 0, 0, null, 0, 0, Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
        }
        return PrivateCellUtil.compareKeyBasedOnColHint(this.rowComparator, nextIndexed, currentCell, currentCell.getFamilyOffset(), currentCell.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength(), Long.MAX_VALUE, KeyValue.Type.Maximum.getCode());
    }

    public abstract Filter getFilter();

    public abstract Cell getNextKeyHint(Cell var1) throws IOException;

    @Override
    public void beforeShipped() throws IOException {
        if (this.currentRow != null) {
            this.currentRow = PrivateCellUtil.createFirstOnRow(CellUtil.copyRow(this.currentRow));
        }
        if (this.columns != null) {
            this.columns.beforeShipped();
        }
    }

    protected static Cell createStartKeyFromRow(byte[] startRow, ScanInfo scanInfo) {
        return PrivateCellUtil.createFirstDeleteFamilyCellOnRow(startRow, scanInfo.getFamily());
    }

    protected static Pair<DeleteTracker, ColumnTracker> getTrackers(RegionCoprocessorHost host, NavigableSet<byte[]> columns, ScanInfo scanInfo, long oldestUnexpiredTS, Scan userScan) throws IOException {
        int resultMaxVersion;
        int maxVersionToCheck = resultMaxVersion = scanInfo.getMaxVersions();
        if (userScan != null) {
            if (userScan.isRaw()) {
                resultMaxVersion = userScan.getMaxVersions();
                maxVersionToCheck = userScan.hasFilter() ? Integer.MAX_VALUE : resultMaxVersion;
            } else {
                resultMaxVersion = Math.min(userScan.getMaxVersions(), scanInfo.getMaxVersions());
                maxVersionToCheck = userScan.hasFilter() ? scanInfo.getMaxVersions() : resultMaxVersion;
            }
        }
        DeleteTracker deleteTracker = scanInfo.isNewVersionBehavior() && (userScan == null || !userScan.isRaw()) ? new NewVersionBehaviorTracker(columns, scanInfo.getComparator(), scanInfo.getMinVersions(), scanInfo.getMaxVersions(), resultMaxVersion, oldestUnexpiredTS) : new ScanDeleteTracker(scanInfo.getComparator());
        if (host != null && (deleteTracker = host.postInstantiateDeleteTracker(deleteTracker)) instanceof VisibilityScanDeleteTracker && scanInfo.isNewVersionBehavior()) {
            deleteTracker = new VisibilityNewVersionBehaivorTracker(columns, scanInfo.getComparator(), scanInfo.getMinVersions(), scanInfo.getMaxVersions(), resultMaxVersion, oldestUnexpiredTS);
        }
        ColumnTracker columnTracker = deleteTracker instanceof NewVersionBehaviorTracker ? (NewVersionBehaviorTracker)deleteTracker : (columns == null || columns.size() == 0 ? new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersionToCheck, oldestUnexpiredTS, scanInfo.getComparator()) : new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersionToCheck, oldestUnexpiredTS));
        return new Pair<DeleteTracker, ColumnTracker>(deleteTracker, columnTracker);
    }

    static MatchCode checkColumn(ColumnTracker columnTracker, byte[] bytes, int offset, int length, long ttl, byte type, boolean ignoreCount) throws IOException {
        KeyValue kv = KeyValueUtil.createFirstOnRow(HConstants.EMPTY_BYTE_ARRAY, 0, 0, HConstants.EMPTY_BYTE_ARRAY, 0, 0, bytes, offset, length);
        MatchCode matchCode = columnTracker.checkColumn(kv, type);
        if (matchCode == MatchCode.INCLUDE) {
            return columnTracker.checkVersions(kv, ttl, type, ignoreCount);
        }
        return matchCode;
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT,
        INCLUDE_AND_SEEK_NEXT_COL,
        INCLUDE_AND_SEEK_NEXT_ROW;

    }
}

