/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.RecoveredReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RecoveredReplicationSourceShipper
extends ReplicationSourceShipper {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveredReplicationSourceShipper.class);
    protected final RecoveredReplicationSource source;
    private final ReplicationQueueStorage replicationQueues;

    public RecoveredReplicationSourceShipper(Configuration conf, String walGroupId, ReplicationSourceLogQueue logQueue, RecoveredReplicationSource source, ReplicationQueueStorage queueStorage) {
        super(conf, walGroupId, logQueue, source);
        this.source = source;
        this.replicationQueues = queueStorage;
    }

    @Override
    protected void noMoreData() {
        LOG.debug("Finished recovering queue for group {} of peer {}", (Object)this.walGroupId, (Object)this.source.getQueueId());
        this.source.getSourceMetrics().incrCompletedRecoveryQueue();
        this.setWorkerState(ReplicationSourceShipper.WorkerState.FINISHED);
    }

    @Override
    protected void postFinish() {
        this.source.tryFinish();
    }

    @Override
    public long getStartPosition() {
        long startPosition = this.getRecoveredQueueStartPos();
        for (int numRetries = 0; numRetries <= this.maxRetriesMultiplier; ++numRetries) {
            try {
                this.source.locateRecoveredPaths(this.walGroupId);
                break;
            }
            catch (IOException e) {
                LOG.error("Error while locating recovered queue paths, attempt #" + numRetries, (Throwable)e);
                continue;
            }
        }
        return startPosition;
    }

    private long getRecoveredQueueStartPos() {
        long startPosition = 0L;
        String peerClusterZNode = this.source.getQueueId();
        try {
            startPosition = this.replicationQueues.getWALPosition(this.source.getServer().getServerName(), peerClusterZNode, this.logQueue.getQueue(this.walGroupId).peek().getName());
            LOG.trace("Recovered queue started with log {} at position {}", (Object)this.logQueue.getQueue(this.walGroupId).peek(), (Object)startPosition);
        }
        catch (ReplicationException e) {
            this.terminate("Couldn't get the position of this recovered queue " + peerClusterZNode, e);
        }
        return startPosition;
    }

    private void terminate(String reason, Exception cause) {
        if (cause == null) {
            LOG.info("Closing worker for wal group {} because: {}", (Object)this.walGroupId, (Object)reason);
        } else {
            LOG.error("Closing worker for wal group " + this.walGroupId + " because an error occurred: " + reason, (Throwable)cause);
        }
        if (this.entryReader != null) {
            this.entryReader.interrupt();
            Threads.shutdown(this.entryReader, this.sleepForRetries);
        }
        this.interrupt();
        Threads.shutdown(this, this.sleepForRetries);
        LOG.info("ReplicationSourceWorker {} terminated", (Object)this.getName());
    }
}

