/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RandomDistribution;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(CompressionTestBase.class);
    protected static final int LARGE_SIZE = 0xA00000;
    protected static final int VERY_LARGE_SIZE = 0x6400000;
    protected static final int BLOCK_SIZE = 4096;
    protected static final byte[] SMALL_INPUT = new byte[4180];

    protected void codecTest(CompressionCodec codec, byte[][] input) throws Exception {
        this.codecTest(codec, input, null);
    }

    protected void codecTest(CompressionCodec codec, byte[][] input, Integer expectedCompressedSize) throws Exception {
        ((Configurable)codec).getConf().setInt("io.file.buffer.size", 32768);
        long start = EnvironmentEdgeManager.currentTime();
        Compressor compressor = codec.createCompressor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressionOutputStream out = codec.createOutputStream((OutputStream)baos, compressor);
        int inLen = 0;
        for (int i = 0; i < input.length; ++i) {
            out.write(input[i]);
            inLen += input[i].length;
        }
        out.close();
        long end = EnvironmentEdgeManager.currentTime();
        byte[] compressed = baos.toByteArray();
        LOG.info("{} compressed {} bytes to {} bytes in {} ms", new Object[]{codec.getClass().getSimpleName(), inLen, compressed.length, end - start});
        if (expectedCompressedSize != null) {
            Assert.assertTrue((String)("Expected compressed size does not match: (expected=" + expectedCompressedSize + ", actual=" + compressed.length + ")"), (expectedCompressedSize == compressed.length ? 1 : 0) != 0);
        }
        byte[] plain = new byte[inLen];
        Decompressor decompressor = codec.createDecompressor();
        CompressionInputStream in = codec.createInputStream((InputStream)new ByteArrayInputStream(compressed), decompressor);
        start = EnvironmentEdgeManager.currentTime();
        IOUtils.readFully((InputStream)in, (byte[])plain, (int)0, (int)plain.length);
        in.close();
        end = EnvironmentEdgeManager.currentTime();
        LOG.info("{} decompressed {} bytes to {} bytes in {} ms", new Object[]{codec.getClass().getSimpleName(), compressed.length, plain.length, end - start});
        int offset = 0;
        for (int i = 0; i < input.length; ++i) {
            Assert.assertTrue((String)("Comparison failed at offset " + offset), (Bytes.compareTo((byte[])plain, (int)offset, (int)input[i].length, (byte[])input[i], (int)0, (int)input[i].length) == 0 ? 1 : 0) != 0);
            offset += input[i].length;
        }
    }

    protected void codecSmallTest(CompressionCodec codec) throws Exception {
        this.codecTest(codec, new byte[][]{SMALL_INPUT});
    }

    protected void codecLargeTest(CompressionCodec codec, double sigma) throws Exception {
        RandomDistribution.Zipf rng = new RandomDistribution.Zipf(new Random(), 0, 127, sigma);
        byte[][] input = new byte[2560][4096];
        CompressionTestBase.fill((RandomDistribution.DiscreteRNG)rng, input);
        this.codecTest(codec, input);
    }

    protected void codecVeryLargeTest(CompressionCodec codec, double sigma) throws Exception {
        RandomDistribution.Zipf rng = new RandomDistribution.Zipf(new Random(), 0, 127, sigma);
        byte[][] input = new byte[1][0x6400000];
        CompressionTestBase.fill((RandomDistribution.DiscreteRNG)rng, input);
        this.codecTest(codec, input);
    }

    protected static void fill(RandomDistribution.DiscreteRNG rng, byte[][] input) {
        for (int i = 0; i < input.length; ++i) {
            CompressionTestBase.fill(rng, input[i]);
        }
    }

    protected static void fill(RandomDistribution.DiscreteRNG rng, byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            input[i] = (byte)rng.nextInt();
        }
    }

    static {
        int off = 0;
        Arrays.fill(SMALL_INPUT, off++, off, (byte)65);
        Arrays.fill(SMALL_INPUT, off++, off, (byte)66);
        Arrays.fill(SMALL_INPUT, off, off += 2, (byte)67);
        Arrays.fill(SMALL_INPUT, off, off += 3, (byte)68);
        Arrays.fill(SMALL_INPUT, off, off += 5, (byte)69);
        Arrays.fill(SMALL_INPUT, off, off += 8, (byte)70);
        Arrays.fill(SMALL_INPUT, off, off += 13, (byte)71);
        Arrays.fill(SMALL_INPUT, off, off += 21, (byte)72);
        Arrays.fill(SMALL_INPUT, off, off += 34, (byte)73);
        Arrays.fill(SMALL_INPUT, off, off += 55, (byte)74);
        Arrays.fill(SMALL_INPUT, off, off += 89, (byte)75);
        Arrays.fill(SMALL_INPUT, off, off += 144, (byte)76);
        Arrays.fill(SMALL_INPUT, off, off += 233, (byte)77);
        Arrays.fill(SMALL_INPUT, off, off += 377, (byte)78);
        Arrays.fill(SMALL_INPUT, off, off += 610, (byte)79);
        Arrays.fill(SMALL_INPUT, off, off += 987, (byte)80);
        Arrays.fill(SMALL_INPUT, off, off += 1597, (byte)81);
    }
}

