/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLoadTestKVGenerator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadTestKVGenerator.class);
    private static final int MIN_LEN = 10;
    private static final int MAX_LEN = 20;
    private Random rand = new Random(28937293L);
    private LoadTestKVGenerator gen = new LoadTestKVGenerator(10, 20);

    @Test
    public void testValueLength() {
        for (int i = 0; i < 1000; ++i) {
            byte[] v = this.gen.generateRandomSizeValue(Bytes.toBytes((String)Integer.toString(i)), Bytes.toBytes((String)String.valueOf(this.rand.nextInt())));
            Assert.assertTrue((10 <= v.length ? 1 : 0) != 0);
            Assert.assertTrue((v.length <= 20 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVerification() {
        for (int i = 0; i < 1000; ++i) {
            for (int qualIndex = 0; qualIndex < 20; ++qualIndex) {
                byte[] qual = Bytes.toBytes((String)String.valueOf(qualIndex));
                byte[] rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey(i));
                byte[] v = this.gen.generateRandomSizeValue(rowKey, qual);
                Assert.assertTrue((boolean)LoadTestKVGenerator.verify(v, rowKey, qual));
                v[0] = (byte)(v[0] + 1);
                Assert.assertFalse((boolean)LoadTestKVGenerator.verify(v, rowKey, qual));
            }
        }
    }

    @Test
    public void testCorrectAndUniqueKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            String k = LoadTestKVGenerator.md5PrefixedKey(i);
            Assert.assertFalse((boolean)keys.contains(k));
            Assert.assertTrue((boolean)k.endsWith("-" + i));
            keys.add(k);
        }
    }
}

