/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class BalanceRequest {
    private static final BalanceRequest DEFAULT = BalanceRequest.newBuilder().build();
    private final boolean dryRun;
    private final boolean ignoreRegionsInTransition;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static BalanceRequest defaultInstance() {
        return DEFAULT;
    }

    private BalanceRequest(boolean dryRun, boolean ignoreRegionsInTransition) {
        this.dryRun = dryRun;
        this.ignoreRegionsInTransition = ignoreRegionsInTransition;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isIgnoreRegionsInTransition() {
        return this.ignoreRegionsInTransition;
    }

    @InterfaceAudience.Public
    public static final class Builder {
        private boolean dryRun = false;
        private boolean ignoreRegionsInTransition = false;

        private Builder() {
        }

        public Builder setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder setIgnoreRegionsInTransition(boolean ignoreRegionsInTransition) {
            this.ignoreRegionsInTransition = ignoreRegionsInTransition;
            return this;
        }

        public BalanceRequest build() {
            return new BalanceRequest(this.dryRun, this.ignoreRegionsInTransition);
        }
    }
}

