/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.metrics.RegionScanMetricsData;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerSideScanMetrics {
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    private final List<RegionScanMetricsData> regionScanMetricsData = new ArrayList<RegionScanMetricsData>(0);
    protected RegionScanMetricsData currentRegionScanMetricsData = null;
    public static final String COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME = "ROWS_SCANNED";
    public static final String COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME = "ROWS_FILTERED";
    public static final String BLOCK_BYTES_SCANNED_KEY_METRIC_NAME = "BLOCK_BYTES_SCANNED";
    public static final String FS_READ_TIME_METRIC_NAME = "FS_READ_TIME";
    public static final String BYTES_READ_FROM_FS_METRIC_NAME = "BYTES_READ_FROM_FS";
    public static final String BYTES_READ_FROM_BLOCK_CACHE_METRIC_NAME = "BYTES_READ_FROM_BLOCK_CACHE";
    public static final String BYTES_READ_FROM_MEMSTORE_METRIC_NAME = "BYTES_READ_FROM_MEMSTORE";
    public static final String BLOCK_READ_OPS_COUNT_METRIC_NAME = "BLOCK_READ_OPS_COUNT";
    public static final String RPC_SCAN_PROCESSING_TIME_METRIC_NAME = "RPC_SCAN_PROCESSING_TIME";
    public static final String RPC_SCAN_QUEUE_WAIT_TIME_METRIC_NAME = "RPC_SCAN_QUEUE_WAIT_TIME";
    @Deprecated
    public static final String COUNT_OF_ROWS_SCANNED_KEY = "ROWS_SCANNED";
    @Deprecated
    public static final String COUNT_OF_ROWS_FILTERED_KEY = "ROWS_FILTERED";
    public final AtomicLong countOfRowsFiltered = this.createCounter("ROWS_FILTERED");
    public final AtomicLong countOfRowsScanned = this.createCounter("ROWS_SCANNED");
    public final AtomicLong countOfBlockBytesScanned = this.createCounter("BLOCK_BYTES_SCANNED");
    public final AtomicLong fsReadTime = this.createCounter("FS_READ_TIME");
    public final AtomicLong bytesReadFromFs = this.createCounter("BYTES_READ_FROM_FS");
    public final AtomicLong bytesReadFromBlockCache = this.createCounter("BYTES_READ_FROM_BLOCK_CACHE");
    public final AtomicLong bytesReadFromMemstore = this.createCounter("BYTES_READ_FROM_MEMSTORE");
    public final AtomicLong blockReadOpsCount = this.createCounter("BLOCK_READ_OPS_COUNT");
    public final AtomicLong rpcScanProcessingTime = this.createCounter("RPC_SCAN_PROCESSING_TIME");
    public final AtomicLong rpcScanQueueWaitTime = this.createCounter("RPC_SCAN_QUEUE_WAIT_TIME");

    public void moveToNextRegion() {
        this.currentRegionScanMetricsData = new RegionScanMetricsData();
        this.regionScanMetricsData.add(this.currentRegionScanMetricsData);
        this.currentRegionScanMetricsData.createCounter("ROWS_SCANNED");
        this.currentRegionScanMetricsData.createCounter("ROWS_FILTERED");
        this.currentRegionScanMetricsData.createCounter(BLOCK_BYTES_SCANNED_KEY_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(FS_READ_TIME_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(BYTES_READ_FROM_FS_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(BYTES_READ_FROM_BLOCK_CACHE_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(BYTES_READ_FROM_MEMSTORE_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(BLOCK_READ_OPS_COUNT_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(RPC_SCAN_PROCESSING_TIME_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(RPC_SCAN_QUEUE_WAIT_TIME_METRIC_NAME);
    }

    protected AtomicLong createCounter(String counterName) {
        return ScanMetricsUtil.createCounter(this.counters, counterName);
    }

    public void setCounter(String counterName, long value) {
        ScanMetricsUtil.setCounter(this.counters, counterName, value);
        if (this.currentRegionScanMetricsData != null) {
            this.currentRegionScanMetricsData.setCounter(counterName, value);
        }
    }

    public boolean hasCounter(String counterName) {
        return ScanMetricsUtil.hasCounter(this.counters, counterName);
    }

    public AtomicLong getCounter(String counterName) {
        return ScanMetricsUtil.getCounter(this.counters, counterName);
    }

    public void addToCounter(String counterName, long delta) {
        ScanMetricsUtil.addToCounter(this.counters, counterName, delta);
        if (this.currentRegionScanMetricsData != null) {
            this.currentRegionScanMetricsData.addToCounter(counterName, delta);
        }
    }

    public Map<String, Long> getMetricsMap() {
        return this.getMetricsMap(true);
    }

    public Map<String, Long> getMetricsMap(boolean reset) {
        return ImmutableMap.copyOf(ScanMetricsUtil.collectMetrics(this.counters, reset));
    }

    public Map<ScanMetricsRegionInfo, Map<String, Long>> collectMetricsByRegion() {
        return this.collectMetricsByRegion(true);
    }

    public Map<ScanMetricsRegionInfo, Map<String, Long>> collectMetricsByRegion(boolean reset) {
        ImmutableMap.Builder<ScanMetricsRegionInfo, Map<String, Long>> builder = ImmutableMap.builder();
        for (RegionScanMetricsData regionScanMetricsData : this.regionScanMetricsData) {
            if (regionScanMetricsData.getScanMetricsRegionInfo() == ScanMetricsRegionInfo.EMPTY_SCAN_METRICS_REGION_INFO) continue;
            builder.put(regionScanMetricsData.getScanMetricsRegionInfo(), regionScanMetricsData.collectMetrics(reset));
        }
        return builder.build();
    }

    public String toString() {
        return this.counters + "," + this.regionScanMetricsData.stream().map(RegionScanMetricsData::toString).collect(Collectors.joining(","));
    }

    public void initScanMetricsRegionInfo(String encodedRegionName, ServerName serverName) {
        this.currentRegionScanMetricsData.initScanMetricsRegionInfo(encodedRegionName, serverName);
    }
}

