/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.proc;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.KeySourceException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.JWK;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.JWKMatcher;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.JWKSelector;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.KeyConverter;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.source.JWKSource;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.proc.JWSKeySelector;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.proc.SecurityContext;
import org.apache.hadoop.hbase.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSVerificationKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final JWSAlgorithm jwsAlg;

    public JWSVerificationKeySelector(JWSAlgorithm jwsAlg, JWKSource<C> jwkSource) {
        super(jwkSource);
        if (jwsAlg == null) {
            throw new IllegalArgumentException("The JWS algorithm must not be null");
        }
        this.jwsAlg = jwsAlg;
    }

    public JWSAlgorithm getExpectedJWSAlgorithm() {
        return this.jwsAlg;
    }

    protected JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
        if (!this.getExpectedJWSAlgorithm().equals(jwsHeader.getAlgorithm())) {
            return null;
        }
        return JWKMatcher.forJWSHeader(jwsHeader);
    }

    @Override
    public List<Key> selectJWSKeys(JWSHeader jwsHeader, C context) throws KeySourceException {
        if (!this.jwsAlg.equals(jwsHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        JWKMatcher jwkMatcher = this.createJWKMatcher(jwsHeader);
        if (jwkMatcher == null) {
            return Collections.emptyList();
        }
        List<JWK> jwkMatches = this.getJWKSource().get(new JWKSelector(jwkMatcher), context);
        LinkedList<Key> sanitizedKeyList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys(jwkMatches)) {
            if (!(key instanceof PublicKey) && !(key instanceof SecretKey)) continue;
            sanitizedKeyList.add(key);
        }
        return sanitizedKeyList;
    }
}

