/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.BufferingScanResultConsumer;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.SimpleScanResultConsumerImpl;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanMetrics.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"ScanMetrics");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection CONN;
    private static int NUM_REGIONS;
    @Parameterized.Parameter(value=0)
    public String methodName;
    @Parameterized.Parameter(value=1)
    public ScanWithMetrics method;

    @Parameterized.Parameters(name="{index}: scan={0}")
    public static List<Object[]> params() {
        ScanWithMetrics doScanWithRawAsyncTable = TestAsyncTableScanMetrics::doScanWithRawAsyncTable;
        ScanWithMetrics doScanWithAsyncTableScan = TestAsyncTableScanMetrics::doScanWithAsyncTableScan;
        ScanWithMetrics doScanWithAsyncTableScanner = TestAsyncTableScanMetrics::doScanWithAsyncTableScanner;
        return Arrays.asList({"doScanWithRawAsyncTable", doScanWithRawAsyncTable}, {"doScanWithAsyncTableScan", doScanWithAsyncTableScan}, {"doScanWithAsyncTableScanner", doScanWithAsyncTableScanner});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        try (Table table = UTIL.createMultiRegionTable(TABLE_NAME, CF);){
            table.put(Arrays.asList(new Put(Bytes.toBytes((String)"xxx1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"yyy1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"zzz1")).addColumn(CF, CQ, VALUE)));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        NUM_REGIONS = UTIL.getHBaseCluster().getRegions(TABLE_NAME).size();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithRawAsyncTable(Scan scan) throws IOException, InterruptedException {
        Result result;
        BufferingScanResultConsumer consumer = new BufferingScanResultConsumer();
        CONN.getTable(TABLE_NAME).scan(scan, (ScanResultConsumerBase)consumer);
        ArrayList<Result> results = new ArrayList<Result>();
        while ((result = consumer.take()) != null) {
            results.add(result);
        }
        return Pair.newPair(results, (Object)consumer.getScanMetrics());
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithAsyncTableScan(Scan scan) throws Exception {
        SimpleScanResultConsumerImpl consumer = new SimpleScanResultConsumerImpl();
        CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool()).scan(scan, (ScanResultConsumerBase)consumer);
        return Pair.newPair(consumer.getAll(), (Object)consumer.getScanMetrics());
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithAsyncTableScanner(Scan scan) throws IOException {
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool()).getScanner(scan);){
            Result result;
            ArrayList<Result> results = new ArrayList<Result>();
            while ((result = scanner.next()) != null) {
                results.add(result);
            }
            Pair pair = Pair.newPair(results, (Object)scanner.getScanMetrics());
            return pair;
        }
    }

    @Test
    public void testScanMetricsDisabled() throws Exception {
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(new Scan());
        Assert.assertEquals((long)3L, (long)((List)pair.getFirst()).size());
        Assert.assertNull((Object)pair.getSecond());
    }

    @Test
    public void testScanMetricsWithScanMetricsByRegionDisabled() throws Exception {
        Scan scan = new Scan();
        scan.setScanMetricsEnabled(true);
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(scan);
        List results = (List)pair.getFirst();
        Assert.assertEquals((long)3L, (long)results.size());
        long bytes = TestAsyncTableScanMetrics.getBytesOfResults(results);
        ScanMetrics scanMetrics = (ScanMetrics)pair.getSecond();
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)bytes, (long)scanMetrics.countOfBytesInResults.get());
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRPCcalls.get());
        Assert.assertTrue((boolean)scanMetrics.collectMetricsByRegion().isEmpty());
    }

    @Test
    public void testScanMetricsByRegionForSingleRegionScan() throws Exception {
        Scan scan = new Scan();
        scan.withStartRow(Bytes.toBytes((String)"zzz1"), true);
        scan.withStopRow(Bytes.toBytes((String)"zzz1"), true);
        scan.setEnableScanMetricsByRegion(true);
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(scan);
        List results = (List)pair.getFirst();
        Assert.assertEquals((long)1L, (long)results.size());
        long bytes = TestAsyncTableScanMetrics.getBytesOfResults(results);
        ScanMetrics scanMetrics = (ScanMetrics)pair.getSecond();
        Assert.assertEquals((long)1L, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)bytes, (long)scanMetrics.countOfBytesInResults.get());
        Assert.assertEquals((long)1L, (long)scanMetrics.countOfRPCcalls.get());
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)1L, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo smri = (ScanMetricsRegionInfo)entry.getKey();
            Map metrics = (Map)entry.getValue();
            Assert.assertNotNull((Object)smri.getServerName());
            Assert.assertNotNull((Object)smri.getEncodedRegionName());
            Assert.assertEquals((Object)scanMetrics.getMetricsMap(false), (Object)metrics);
        }
    }

    @Test
    public void testScanMetricsByRegionForMultiRegionScan() throws Exception {
        Scan scan = new Scan();
        scan.setEnableScanMetricsByRegion(true);
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(scan);
        List results = (List)pair.getFirst();
        Assert.assertEquals((long)3L, (long)results.size());
        long bytes = TestAsyncTableScanMetrics.getBytesOfResults(results);
        ScanMetrics scanMetrics = (ScanMetrics)pair.getSecond();
        Map overallMetrics = scanMetrics.getMetricsMap(false);
        Assert.assertEquals((long)NUM_REGIONS, (long)((Long)overallMetrics.get("REGIONS_SCANNED")));
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)bytes, (long)((Long)overallMetrics.get("BYTES_IN_RESULTS")));
        Assert.assertEquals((long)bytes, (long)scanMetrics.countOfBytesInResults.get());
        Assert.assertEquals((long)NUM_REGIONS, (long)((Long)overallMetrics.get("RPC_CALLS")));
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRPCcalls.get());
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion(false);
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetricsByRegion.size());
        int rowsScannedAcrossAllRegions = 0;
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo smri = (ScanMetricsRegionInfo)entry.getKey();
            Map perRegionMetrics = (Map)entry.getValue();
            Assert.assertNotNull((Object)smri.getServerName());
            Assert.assertNotNull((Object)smri.getEncodedRegionName());
            Assert.assertEquals((long)1L, (long)((Long)perRegionMetrics.get("REGIONS_SCANNED")));
            if ((Long)perRegionMetrics.get("ROWS_SCANNED") == 1L) {
                bytes = TestAsyncTableScanMetrics.getBytesOfResults(Collections.singletonList(results.get(0)));
                Assert.assertEquals((long)bytes, (long)((Long)perRegionMetrics.get("BYTES_IN_RESULTS")));
                ++rowsScannedAcrossAllRegions;
                continue;
            }
            Assert.assertEquals((long)0L, (long)((Long)perRegionMetrics.get("ROWS_SCANNED")));
            Assert.assertEquals((long)0L, (long)((Long)perRegionMetrics.get("BYTES_IN_RESULTS")));
        }
        Assert.assertEquals((long)3L, (long)rowsScannedAcrossAllRegions);
    }

    static long getBytesOfResults(List<Result> results) {
        return results.stream().flatMap(r -> Arrays.asList(r.rawCells()).stream()).mapToLong(c -> PrivateCellUtil.estimatedSerializedSizeOf((Cell)c)).sum();
    }

    @FunctionalInterface
    private static interface ScanWithMetrics {
        public Pair<List<Result>, ScanMetrics> scan(Scan var1) throws Exception;
    }
}

