/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.DelegatingHBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestRequestAttributes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRequestAttributes.class);
    private static final byte[] ROW_KEY1 = Bytes.toBytes((String)"1");
    private static final byte[] ROW_KEY2A = Bytes.toBytes((String)"2A");
    private static final byte[] ROW_KEY2B = Bytes.toBytes((String)"2B");
    private static final byte[] ROW_KEY3 = Bytes.toBytes((String)"3");
    private static final byte[] ROW_KEY4 = Bytes.toBytes((String)"4");
    private static final byte[] ROW_KEY5 = Bytes.toBytes((String)"5");
    private static final byte[] ROW_KEY6 = Bytes.toBytes((String)"6");
    private static final byte[] ROW_KEY7 = Bytes.toBytes((String)"7");
    private static final byte[] ROW_KEY8 = Bytes.toBytes((String)"8");
    private static final Map<String, byte[]> CONNECTION_ATTRIBUTES = new HashMap<String, byte[]>();
    private static final Map<String, byte[]> REQUEST_ATTRIBUTES_SCAN = TestRequestAttributes.addRandomRequestAttributes();
    private static final Map<byte[], Map<String, byte[]>> ROW_KEY_TO_REQUEST_ATTRIBUTES = new HashMap<byte[], Map<String, byte[]>>();
    private static final ExecutorService EXECUTOR_SERVICE;
    private static final byte[] FAMILY;
    private static final TableName TABLE_NAME;
    private static final HBaseTestingUtility TEST_UTIL;
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(1);
        Table table = TEST_UTIL.createTable(TABLE_NAME, (byte[][])new byte[][]{FAMILY}, 1, 65536, AttributesCoprocessor.class.getName());
        table.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        cluster.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRequestAttributesGet() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY1)).build();){
            table.get(new Get(ROW_KEY1));
        }
    }

    @Test
    public void testRequestAttributesMultiGet() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY2A)).build();){
            ArrayList<Get> gets = new ArrayList<Get>(2);
            gets.add(new Get(ROW_KEY2A));
            gets.add(new Get(ROW_KEY2B));
            table.get(gets);
        }
    }

    @Test
    public void testRequestAttributesScan() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), REQUEST_ATTRIBUTES_SCAN).build();){
            ResultScanner scanner = table.getScanner(new Scan());
            scanner.next();
        }
    }

    @Test
    public void testRequestAttributesPut() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY3)).build();){
            Put put = new Put(ROW_KEY3);
            put.addColumn(FAMILY, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
            table.put(put);
        }
    }

    @Test
    public void testRequestAttributesMultiPut() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY4)).build();){
            Put put1 = new Put(ROW_KEY4);
            put1.addColumn(FAMILY, Bytes.toBytes((String)"c1"), Bytes.toBytes((String)"v1"));
            Put put2 = new Put(ROW_KEY4);
            put2.addColumn(FAMILY, Bytes.toBytes((String)"c2"), Bytes.toBytes((String)"v2"));
            ArrayList<Put> puts = new ArrayList<Put>(2);
            puts.add(put1);
            puts.add(put1);
            table.put(puts);
        }
    }

    @Test
    public void testRequestAttributesBufferedMutate() throws IOException, InterruptedException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             BufferedMutator bufferedMutator = conn.getBufferedMutator(TestRequestAttributes.configureRequestAttributes(new BufferedMutatorParams(TABLE_NAME), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY5)));){
            Put put = new Put(ROW_KEY5);
            put.addColumn(FAMILY, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
            bufferedMutator.mutate((Mutation)put);
            bufferedMutator.flush();
        }
    }

    @Test
    public void testRequestAttributesExists() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = TestRequestAttributes.configureRequestAttributes(conn.getTableBuilder(TABLE_NAME, EXECUTOR_SERVICE), ROW_KEY_TO_REQUEST_ATTRIBUTES.get(ROW_KEY6)).build();){
            table.exists(new Get(ROW_KEY6));
        }
    }

    @Test
    public void testRequestAttributesFromRpcController() throws IOException, InterruptedException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.rpc.controllerfactory.class", RequestMetadataControllerFactory.class, RpcControllerFactory.class);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             BufferedMutator bufferedMutator = conn.getBufferedMutator(TABLE_NAME);){
            Put put = new Put(ROW_KEY7);
            put.addColumn(FAMILY, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
            bufferedMutator.mutate((Mutation)put);
            bufferedMutator.flush();
        }
        conf.unset("hbase.rpc.controllerfactory.class");
    }

    @Test
    public void testNoRequestAttributes() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);){
            TableBuilder tableBuilder = conn.getTableBuilder(TABLE_NAME, null);
            try (Table table = tableBuilder.build();){
                table.get(new Get(ROW_KEY8));
            }
        }
    }

    private static Map<String, byte[]> addRandomRequestAttributes() {
        HashMap<String, byte[]> requestAttributes = new HashMap<String, byte[]>();
        int j = Math.max(2, (int)(10.0 * Math.random()));
        for (int i = 0; i < j; ++i) {
            requestAttributes.put(String.valueOf(i), Bytes.toBytes((String)UUID.randomUUID().toString()));
        }
        return requestAttributes;
    }

    private static TableBuilder configureRequestAttributes(TableBuilder tableBuilder, Map<String, byte[]> requestAttributes) {
        requestAttributes.forEach((arg_0, arg_1) -> ((TableBuilder)tableBuilder).setRequestAttribute(arg_0, arg_1));
        return tableBuilder;
    }

    private static BufferedMutatorParams configureRequestAttributes(BufferedMutatorParams params, Map<String, byte[]> requestAttributes) {
        requestAttributes.forEach((arg_0, arg_1) -> ((BufferedMutatorParams)params).setRequestAttribute(arg_0, arg_1));
        return params;
    }

    static /* synthetic */ byte[] access$000() {
        return ROW_KEY7;
    }

    static {
        CONNECTION_ATTRIBUTES.put("clientId", Bytes.toBytes((String)"foo"));
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY1, TestRequestAttributes.addRandomRequestAttributes());
        Map<String, byte[]> requestAttributes2 = TestRequestAttributes.addRandomRequestAttributes();
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY2A, requestAttributes2);
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY2B, requestAttributes2);
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY3, TestRequestAttributes.addRandomRequestAttributes());
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY4, TestRequestAttributes.addRandomRequestAttributes());
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY5, TestRequestAttributes.addRandomRequestAttributes());
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY6, TestRequestAttributes.addRandomRequestAttributes());
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY7, TestRequestAttributes.addRandomRequestAttributes());
        ROW_KEY_TO_REQUEST_ATTRIBUTES.put(ROW_KEY8, new HashMap());
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(100);
        FAMILY = Bytes.toBytes((String)"0");
        TABLE_NAME = TableName.valueOf((String)"testRequestAttributes");
        TEST_UTIL = new HBaseTestingUtility();
    }

    public static class AttributesCoprocessor
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            if (!this.isValidRequestAttributes(this.getRequestAttributesForRowKey(get.getRow()))) {
                throw new IOException("Incorrect request attributes");
            }
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
            if (!this.isValidRequestAttributes(REQUEST_ATTRIBUTES_SCAN)) {
                throw new IOException("Incorrect request attributes");
            }
            return hasNext;
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit) throws IOException {
            if (!this.isValidRequestAttributes(this.getRequestAttributesForRowKey(put.getRow()))) {
                throw new IOException("Incorrect request attributes");
            }
        }

        private Map<String, byte[]> getRequestAttributesForRowKey(byte[] rowKey) {
            for (byte[] byteArray : ROW_KEY_TO_REQUEST_ATTRIBUTES.keySet()) {
                if (!Arrays.equals(byteArray, rowKey)) continue;
                return (Map)ROW_KEY_TO_REQUEST_ATTRIBUTES.get(byteArray);
            }
            return null;
        }

        private boolean isValidRequestAttributes(Map<String, byte[]> requestAttributes) {
            RpcCall rpcCall = (RpcCall)RpcServer.getCurrentCall().get();
            Map attrs = rpcCall.getRequestAttributes();
            if (attrs.size() != requestAttributes.size()) {
                return false;
            }
            for (Map.Entry attr : attrs.entrySet()) {
                if (!requestAttributes.containsKey(attr.getKey())) {
                    return false;
                }
                if (Arrays.equals(requestAttributes.get(attr.getKey()), (byte[])attr.getValue())) continue;
                return false;
            }
            return true;
        }
    }

    public static class RequestMetadataControllerFactory
    extends RpcControllerFactory {
        public RequestMetadataControllerFactory(Configuration conf) {
            super(conf);
        }

        public HBaseRpcController newController() {
            return new RequestMetadataController(super.newController());
        }

        public HBaseRpcController newController(CellScanner cellScanner) {
            return new RequestMetadataController(super.newController(null, cellScanner));
        }

        public HBaseRpcController newController(RegionInfo regionInfo, CellScanner cellScanner) {
            return new RequestMetadataController(super.newController(regionInfo, cellScanner));
        }

        public HBaseRpcController newController(List<CellScannable> cellIterables) {
            return new RequestMetadataController(super.newController(null, cellIterables));
        }

        public HBaseRpcController newController(RegionInfo regionInfo, List<CellScannable> cellIterables) {
            return new RequestMetadataController(super.newController(regionInfo, cellIterables));
        }

        public static class RequestMetadataController
        extends DelegatingHBaseRpcController {
            private final Map<String, byte[]> requestAttributes = (Map)TestRequestAttributes.access$100().get(TestRequestAttributes.access$000());

            RequestMetadataController(HBaseRpcController delegate) {
                super(delegate);
            }

            public Map<String, byte[]> getRequestAttributes() {
                return this.requestAttributes;
            }
        }
    }
}

