/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.http.RegionVisualizer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionVisualizer {
    @ClassRule
    public static final HBaseClassTestRule testRule = HBaseClassTestRule.forClass(TestRegionVisualizer.class);
    private static final Random rand = new Random();
    private static List<Method> regionMetricsBuilderLongValueSetters;

    @BeforeClass
    public static void beforeClass() {
        regionMetricsBuilderLongValueSetters = Arrays.stream(RegionMetricsBuilder.class.getDeclaredMethods()).filter(method -> method.getName().startsWith("set")).filter(method -> method.getParameterTypes().length == 1).filter(method -> Objects.equals(method.getParameterTypes()[0], Long.TYPE)).collect(Collectors.toList());
    }

    @Test
    public void testRegionDetailsJsonSerialization() throws Exception {
        ServerName serverName = ServerName.valueOf((String)"example.org", (int)1234, (long)System.currentTimeMillis());
        TableName tableName = TableName.valueOf((String)"foo", (String)"bar");
        RegionVisualizer.RegionDetails regionDetails = new RegionVisualizer.RegionDetails(serverName, tableName, this.buildRegionMetrics(tableName));
        Gson gson = RegionVisualizer.buildGson();
        JsonObject result = (JsonObject)gson.fromJson(gson.toJson((Object)regionDetails), JsonObject.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)serverName.toShortString(), (Object)result.get("server_name").getAsString());
        Assert.assertEquals((Object)tableName.getNameAsString(), (Object)result.get("table_name").getAsString());
    }

    final RegionMetrics buildRegionMetrics(TableName tableName) throws Exception {
        ArrayList<Method> setters = new ArrayList<Method>(regionMetricsBuilderLongValueSetters);
        Collections.shuffle(setters, rand);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        RegionMetricsBuilder builder = RegionMetricsBuilder.newBuilder((byte[])regionInfo.getRegionName());
        for (Method setter : setters.subList(0, 3)) {
            setter.invoke((Object)builder, rand.nextLong());
        }
        return builder.build();
    }
}

