/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.TimeBasedLimiter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestQuotaCache2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaCache2.class);
    private static final Configuration conf = HBaseConfiguration.create();

    @Test
    public void testPreserveLimiterAvailability() throws Exception {
        QuotaState oldState = new QuotaState();
        HashMap<String, QuotaState> oldCache = new HashMap<String, QuotaState>();
        oldCache.put("my_table", oldState);
        QuotaProtos.Throttle throttle1 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(100L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter1 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle1);
        oldState.setGlobalLimiter(limiter1);
        limiter1.consumeRead(1L, 1L, false);
        QuotaState newState = new QuotaState();
        HashMap<String, QuotaState> newCache = new HashMap<String, QuotaState>();
        newCache.put("my_table", newState);
        QuotaProtos.Throttle throttle2 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(100L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter2 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle2);
        newState.setGlobalLimiter(limiter2);
        QuotaCache.updateNewCacheFromOld(oldCache, newCache);
        TimeBasedLimiter updatedLimiter = (TimeBasedLimiter)((QuotaState)newCache.get("my_table")).getGlobalLimiter();
        Assert.assertEquals((long)99L, (long)updatedLimiter.getReadAvailable());
    }

    @Test
    public void testClobberLimiterLimit() throws Exception {
        QuotaState oldState = new QuotaState();
        HashMap<String, QuotaState> oldCache = new HashMap<String, QuotaState>();
        oldCache.put("my_table", oldState);
        QuotaProtos.Throttle throttle1 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(100L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter1 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle1);
        oldState.setGlobalLimiter(limiter1);
        QuotaState newState = new QuotaState();
        HashMap<String, QuotaState> newCache = new HashMap<String, QuotaState>();
        newCache.put("my_table", newState);
        QuotaProtos.Throttle throttle2 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(50L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter2 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle2);
        newState.setGlobalLimiter(limiter2);
        QuotaCache.updateNewCacheFromOld(oldCache, newCache);
        TimeBasedLimiter updatedLimiter = (TimeBasedLimiter)((QuotaState)newCache.get("my_table")).getGlobalLimiter();
        Assert.assertEquals((long)50L, (long)updatedLimiter.getReadLimit());
    }

    @Test
    public void testForgetsDeletedQuota() {
        QuotaState oldState = new QuotaState();
        HashMap<String, QuotaState> oldCache = new HashMap<String, QuotaState>();
        oldCache.put("my_table1", oldState);
        QuotaState newState = new QuotaState();
        HashMap<String, QuotaState> newCache = new HashMap<String, QuotaState>();
        newCache.put("my_table2", newState);
        QuotaCache.updateNewCacheFromOld(oldCache, newCache);
        Assert.assertTrue((boolean)newCache.containsKey("my_table2"));
        Assert.assertFalse((boolean)newCache.containsKey("my_table1"));
    }

    @Test
    public void testLearnsNewQuota() {
        HashMap oldCache = new HashMap();
        QuotaState newState = new QuotaState();
        HashMap<String, QuotaState> newCache = new HashMap<String, QuotaState>();
        newCache.put("my_table1", newState);
        QuotaCache.updateNewCacheFromOld(oldCache, newCache);
        Assert.assertTrue((boolean)newCache.containsKey("my_table1"));
    }

    @Test
    public void testUserSpecificOverridesDefaultNewQuota() {
        QuotaState oldState = new QuotaState();
        HashMap<String, QuotaState> oldCache = new HashMap<String, QuotaState>();
        oldCache.put("my_table", oldState);
        QuotaProtos.Throttle throttle1 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(100L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter1 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle1);
        oldState.setGlobalLimiter(limiter1);
        QuotaState newState = new QuotaState();
        HashMap<String, QuotaState> newCache = new HashMap<String, QuotaState>();
        newCache.put("my_table", newState);
        QuotaProtos.Throttle throttle2 = QuotaProtos.Throttle.newBuilder().setReadSize(QuotaProtos.TimedQuota.newBuilder().setTimeUnit(HBaseProtos.TimeUnit.SECONDS).setSoftLimit(999L).setScope(QuotaProtos.QuotaScope.MACHINE).build()).build();
        QuotaLimiter limiter2 = TimeBasedLimiter.fromThrottle((Configuration)conf, (QuotaProtos.Throttle)throttle2);
        newState.setGlobalLimiter(limiter2);
        QuotaCache.updateNewCacheFromOld(oldCache, newCache);
        TimeBasedLimiter updatedLimiter = (TimeBasedLimiter)((QuotaState)newCache.get("my_table")).getGlobalLimiter();
        Assert.assertEquals((long)999L, (long)updatedLimiter.getReadAvailable());
    }
}

