/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestOutputSinkWriter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOutputSinkWriter.class);

    @Test
    public void testExeptionHandling() throws IOException, InterruptedException {
        WALSplitter.PipelineController controller = new WALSplitter.PipelineController();
        BrokenEntryBuffers entryBuffers = new BrokenEntryBuffers(controller, 2000L);
        OutputSink sink = new OutputSink(controller, entryBuffers, 1){

            protected int getNumOpenWriters() {
                return 0;
            }

            protected void append(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
            }

            protected List<Path> close() throws IOException {
                return null;
            }

            public Map<String, Long> getOutputCounts() {
                return null;
            }

            public int getNumberOfRecoveredRegions() {
                return 0;
            }

            public boolean keepRegionEvent(WAL.Entry entry) {
                return false;
            }
        };
        sink.startWriterThreads();
        Thread.sleep(1000L);
        try {
            controller.checkForErrors();
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)true);
        }
        sink.restartWriterThreadsIfNeeded();
        try {
            controller.checkForErrors();
        }
        catch (RuntimeException re) {
            Assert.fail();
        }
        entryBuffers.setThrowError(true);
        Thread.sleep(1000L);
        try {
            controller.checkForErrors();
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)true);
        }
    }

    static class BrokenEntryBuffers
    extends EntryBuffers {
        boolean throwError = true;

        public BrokenEntryBuffers(WALSplitter.PipelineController controller, long maxHeapUsage) {
            super(controller, maxHeapUsage);
        }

        synchronized EntryBuffers.RegionEntryBuffer getChunkToWrite() {
            if (this.throwError) {
                this.throwError = false;
                throw new RuntimeException("testing");
            }
            return null;
        }

        public void setThrowError(boolean newValue) {
            this.throwError = newValue;
        }
    }
}

