/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.AdminAuthorizedFilter;
import org.apache.hadoop.hbase.http.AdminAuthorizedServlet;
import org.apache.hadoop.hbase.http.ClickjackingPreventionFilter;
import org.apache.hadoop.hbase.http.FilterContainer;
import org.apache.hadoop.hbase.http.FilterInitializer;
import org.apache.hadoop.hbase.http.HtmlQuoting;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpRequestLog;
import org.apache.hadoop.hbase.http.NoCacheFilter;
import org.apache.hadoop.hbase.http.ProfileOutputServlet;
import org.apache.hadoop.hbase.http.ProfileServlet;
import org.apache.hadoop.hbase.http.ProxyUserAuthenticationFilter;
import org.apache.hadoop.hbase.http.SecurityHeadersFilter;
import org.apache.hadoop.hbase.http.conf.ConfServlet;
import org.apache.hadoop.hbase.http.jmx.JMXJsonServlet;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.org.eclipse.jetty.http.HttpVersion;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.ConnectionFactory;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Connector;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Handler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.HandlerContainer;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.HttpConfiguration;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.HttpConnectionFactory;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.RequestLog;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.SecureRequestCustomizer;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Server;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.ServerConnector;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.SslConnectionFactory;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.handler.RequestLogHandler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.DefaultServlet;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.FilterMapping;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.MultiException;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.thread.ThreadPool;
import org.apache.hbase.thirdparty.org.eclipse.jetty.webapp.WebAppContext;
import org.apache.hbase.thirdparty.org.glassfish.jersey.server.ResourceConfig;
import org.apache.hbase.thirdparty.org.glassfish.jersey.servlet.ServletContainer;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HttpServer
implements FilterContainer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_MAX_HEADER_SIZE = 65534;
    static final String FILTER_INITIALIZERS_PROPERTY = "hbase.http.filter.initializers";
    static final String HTTP_MAX_THREADS = "hbase.http.max.threads";
    public static final String HTTP_UI_AUTHENTICATION = "hbase.security.authentication.ui";
    static final String HTTP_AUTHENTICATION_PREFIX = "hbase.security.authentication.";
    static final String HTTP_SPNEGO_AUTHENTICATION_PREFIX = "hbase.security.authentication.spnego.";
    static final String HTTP_SPNEGO_AUTHENTICATION_PRINCIPAL_SUFFIX = "kerberos.principal";
    public static final String HTTP_SPNEGO_AUTHENTICATION_PRINCIPAL_KEY = "hbase.security.authentication.spnego.kerberos.principal";
    static final String HTTP_SPNEGO_AUTHENTICATION_KEYTAB_SUFFIX = "kerberos.keytab";
    public static final String HTTP_SPNEGO_AUTHENTICATION_KEYTAB_KEY = "hbase.security.authentication.spnego.kerberos.keytab";
    static final String HTTP_SPNEGO_AUTHENTICATION_KRB_NAME_SUFFIX = "kerberos.name.rules";
    public static final String HTTP_SPNEGO_AUTHENTICATION_KRB_NAME_KEY = "hbase.security.authentication.spnego.kerberos.name.rules";
    static final String HTTP_SPNEGO_AUTHENTICATION_PROXYUSER_ENABLE_SUFFIX = "kerberos.proxyuser.enable";
    public static final String HTTP_SPNEGO_AUTHENTICATION_PROXYUSER_ENABLE_KEY = "hbase.security.authentication.spnego.kerberos.proxyuser.enable";
    public static final boolean HTTP_SPNEGO_AUTHENTICATION_PROXYUSER_ENABLE_DEFAULT = false;
    static final String HTTP_AUTHENTICATION_SIGNATURE_SECRET_FILE_SUFFIX = "signature.secret.file";
    public static final String HTTP_AUTHENTICATION_SIGNATURE_SECRET_FILE_KEY = "hbase.security.authentication.signature.secret.file";
    public static final String HTTP_SPNEGO_AUTHENTICATION_ADMIN_USERS_KEY = "hbase.security.authentication.spnego.admin.users";
    public static final String HTTP_SPNEGO_AUTHENTICATION_ADMIN_GROUPS_KEY = "hbase.security.authentication.spnego.admin.groups";
    static final String HTTP_LDAP_AUTHENTICATION_PREFIX = "hbase.security.authentication.ldap.";
    public static final String HTTP_LDAP_AUTHENTICATION_ADMIN_USERS_KEY = "hbase.security.authentication.ldap.admin.users";
    public static final String HTTP_PRIVILEGED_CONF_KEY = "hbase.security.authentication.ui.config.protected";
    public static final boolean HTTP_PRIVILEGED_CONF_DEFAULT = false;
    public static final String CONF_CONTEXT_ATTRIBUTE = "hbase.conf";
    public static final String ADMINS_ACL = "admins.acl";
    public static final String BIND_ADDRESS = "bind.address";
    public static final String SPNEGO_FILTER = "SpnegoFilter";
    public static final String SPNEGO_PROXYUSER_FILTER = "SpnegoProxyUserFilter";
    public static final String NO_CACHE_FILTER = "NoCacheFilter";
    public static final String APP_DIR = "webapps";
    private final AccessControlList adminsAcl;
    protected final Server webServer;
    protected String appDir;
    protected String logDir;
    private final List<ListenerInfo> listeners = Lists.newArrayList();
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<ServletContextHandler, Boolean> defaultContexts = new HashMap<ServletContextHandler, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    protected final boolean authenticationEnabled;
    static final String STATE_DESCRIPTION_ALIVE = " - alive";
    static final String STATE_DESCRIPTION_NOT_LIVE = " - not live";

    public List<ServerConnector> getServerConnectors() {
        return this.listeners.stream().map(info -> ((ListenerInfo)info).listener).collect(Collectors.toList());
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this(name, bindAddress, port, findPort, new Configuration());
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, String[] pathSpecs) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, pathSpecs);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, String[] pathSpecs) throws IOException {
        this(new Builder().setName(name).addEndpoint(URI.create("http://" + bindAddress + ":" + port)).setFindPort(findPort).setConf(conf).setACL(adminsAcl).setPathSpec(pathSpecs));
    }

    private HttpServer(Builder b) throws IOException {
        this.appDir = b.appDir;
        this.logDir = b.logDir;
        String appDir = this.getWebAppsPath(b.name);
        int maxThreads = b.conf.getInt(HTTP_MAX_THREADS, 16);
        QueuedThreadPool threadPool = maxThreads <= 0 ? new QueuedThreadPool() : new QueuedThreadPool(maxThreads);
        threadPool.setDaemon(true);
        this.webServer = new Server((ThreadPool)threadPool);
        this.adminsAcl = b.adminsAcl;
        this.webAppContext = HttpServer.createWebAppContext(b.name, b.conf, this.adminsAcl, appDir);
        this.findPort = b.findPort;
        this.authenticationEnabled = b.securityEnabled;
        this.initializeWebServer(b.name, b.hostName, b.conf, b.pathSpecs, b);
        this.webServer.setHandler((Handler)HttpServer.buildGzipHandler(this.webServer.getHandler()));
    }

    private void initializeWebServer(String name, String hostName, Configuration conf, String[] pathSpecs, Builder b) throws FileNotFoundException, IOException {
        FilterInitializer[] initializers;
        Preconditions.checkNotNull((Object)this.webAppContext);
        HandlerCollection handlerCollection = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLog requestLog = HttpRequestLog.getRequestLog(name);
        if (requestLog != null) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(requestLog);
            handlerCollection.addHandler((Handler)requestLogHandler);
        }
        String appDir = this.getWebAppsPath(name);
        handlerCollection.addHandler((Handler)contexts);
        handlerCollection.addHandler((Handler)this.webAppContext);
        this.webServer.setHandler((Handler)handlerCollection);
        this.webAppContext.setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
        this.addDefaultApps(contexts, appDir, conf);
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), null);
        this.addGlobalFilter("clickjackingprevention", ClickjackingPreventionFilter.class.getName(), ClickjackingPreventionFilter.getDefaultParameters(conf));
        HttpConfig httpConfig = new HttpConfig(conf);
        this.addGlobalFilter("securityheaders", SecurityHeadersFilter.class.getName(), SecurityHeadersFilter.getDefaultParameters(conf, httpConfig.isSecure()));
        if (this.authenticationEnabled) {
            this.initSpnego(conf, hostName, b.usernameConfKey, b.keytabConfKey, b.kerberosNameRulesKey, b.signatureSecretFileKey);
        }
        if ((initializers = HttpServer.getFilterInitializers(conf)) != null) {
            conf = new Configuration(conf);
            conf.set(BIND_ADDRESS, hostName);
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets(contexts, conf);
        if (pathSpecs != null) {
            for (String path : pathSpecs) {
                LOG.info("adding path spec: " + (String)path);
                this.addFilterPathMapping(path, this.webAppContext);
            }
        }
    }

    private void addManagedListener(ServerConnector connector) {
        this.listeners.add(new ListenerInfo(true, connector));
    }

    private static WebAppContext createWebAppContext(String name, Configuration conf, AccessControlList adminsAcl, String appDir) {
        WebAppContext ctx = new WebAppContext();
        ctx.setDisplayName(name);
        ctx.setContextPath("/");
        ctx.setWar(appDir + "/" + name);
        ctx.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        ctx.getServletContext().setAttribute("hadoop.conf", (Object)conf);
        ctx.getServletContext().setAttribute(ADMINS_ACL, (Object)adminsAcl);
        HttpServer.addNoCacheFilter(ctx);
        return ctx;
    }

    public static GzipHandler buildGzipHandler(Handler wrapped) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setHandler(wrapped);
        return gzipHandler;
    }

    private static void addNoCacheFilter(WebAppContext ctxt) {
        HttpServer.defineFilter((ServletContextHandler)ctxt, NO_CACHE_FILTER, NoCacheFilter.class.getName(), Collections.emptyMap(), new String[]{"/*"});
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class[] classes = conf.getClasses(FILTER_INITIALIZERS_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance((Class)classes[i], (Object[])new Object[0]);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir, Configuration conf) {
        String logDir = this.logDir;
        if (logDir == null) {
            logDir = System.getProperty("hadoop.log.dir");
        }
        if (logDir != null) {
            ServletContextHandler logContext = new ServletContextHandler((HandlerContainer)parent, "/logs");
            logContext.addServlet(AdminAuthorizedServlet.class, "/*");
            logContext.setResourceBase(logDir);
            if (conf.getBoolean("hbase.jetty.logs.serve.aliases", true)) {
                Map params = logContext.getInitParams();
                params.put("org.mortbay.jetty.servlet.Default.aliases", "true");
            }
            logContext.setDisplayName("logs");
            this.setContextAttributes(logContext, conf);
            this.defaultContexts.put(logContext, true);
        }
        ServletContextHandler staticContext = new ServletContextHandler((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        this.setContextAttributes(staticContext, conf);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(ServletContextHandler context, Configuration conf) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        context.getServletContext().setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
    }

    protected void addDefaultServlets(ContextHandlerCollection contexts, Configuration conf) throws IOException {
        this.addPrivilegedServlet("stacks", "/stacks", StackServlet.class);
        this.addPrivilegedServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        try {
            Class<?> clz = Class.forName("org.apache.hadoop.metrics.MetricsServlet");
            this.addPrivilegedServlet("metrics", "/metrics", clz.asSubclass(HttpServlet.class));
        }
        catch (Exception clz) {
            // empty catch block
        }
        this.addPrivilegedServlet("jmx", "/jmx", JMXJsonServlet.class);
        if (conf.getBoolean(HTTP_PRIVILEGED_CONF_KEY, false)) {
            this.addPrivilegedServlet("conf", "/conf", ConfServlet.class);
        } else {
            this.addUnprivilegedServlet("conf", "/conf", ConfServlet.class);
        }
        String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
        if (asyncProfilerHome != null && !asyncProfilerHome.trim().isEmpty()) {
            this.addPrivilegedServlet("prof", "/prof", ProfileServlet.class);
            Path tmpDir = Paths.get(ProfileServlet.OUTPUT_DIR, new String[0]);
            if (Files.notExists(tmpDir, new LinkOption[0])) {
                Files.createDirectories(tmpDir, new FileAttribute[0]);
            }
            ServletContextHandler genCtx = new ServletContextHandler((HandlerContainer)contexts, "/prof-output-hbase");
            genCtx.addServlet(ProfileOutputServlet.class, "/*");
            genCtx.setResourceBase(tmpDir.toAbsolutePath().toString());
            genCtx.setDisplayName("prof-output-hbase");
        } else {
            this.addUnprivilegedServlet("prof", "/prof", ProfileServlet.DisabledServlet.class);
            LOG.info("ASYNC_PROFILER_HOME environment variable and async.profiler.home system property not specified. Disabling /prof endpoint.");
        }
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec) {
        LOG.info("addJerseyResourcePackage: packageName=" + packageName + ", pathSpec=" + pathSpec);
        ResourceConfig application = new ResourceConfig().packages(new String[]{packageName});
        ServletHolder sh = new ServletHolder((Servlet)new ServletContainer(application));
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addUnprivilegedServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addServletWithAuth(name, pathSpec, clazz, false);
    }

    public void addUnprivilegedServlet(String pathSpec, ServletHolder holder) {
        this.addServletWithAuth(pathSpec, holder, false);
    }

    public void addPrivilegedServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addServletWithAuth(name, pathSpec, clazz, true);
    }

    public void addPrivilegedServlet(String pathSpec, ServletHolder holder) {
        this.addServletWithAuth(pathSpec, holder, true);
    }

    void addServletWithAuth(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuthz) {
        this.addInternalServlet(name, pathSpec, clazz, requireAuthz);
        this.addFilterPathMapping(pathSpec, this.webAppContext);
    }

    void addServletWithAuth(String pathSpec, ServletHolder holder, boolean requireAuthz) {
        this.addInternalServlet(pathSpec, holder, requireAuthz);
        this.addFilterPathMapping(pathSpec, this.webAppContext);
    }

    void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuthz) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.addInternalServlet(pathSpec, holder, requireAuthz);
    }

    void addInternalServlet(String pathSpec, ServletHolder holder, boolean requireAuthz) {
        if (this.authenticationEnabled && requireAuthz) {
            FilterHolder filter = new FilterHolder(AdminAuthorizedFilter.class);
            filter.setName(AdminAuthorizedFilter.class.getSimpleName());
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setDispatches(31);
            fmap.setFilterName(AdminAuthorizedFilter.class.getSimpleName());
            this.webAppContext.getServletHandler().addFilter(filter, fmap);
        }
        this.webAppContext.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        this.webAppContext.getSessionHandler().getSessionCookieConfig().setSecure(true);
        this.webAppContext.addServlet(holder, pathSpec);
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        HttpServer.defineFilter((ServletContextHandler)this.webAppContext, name, classname, parameters, USER_FACING_URLS);
        LOG.info("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName());
        String[] ALL_URLS = new String[]{"/*"};
        for (Map.Entry<ServletContextHandler, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            ServletContextHandler handler = e.getKey();
            HttpServer.defineFilter(handler, name, classname, parameters, ALL_URLS);
            LOG.info("Added filter " + name + " (class=" + classname + ") to context " + handler.getDisplayName());
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        HttpServer.defineFilter((ServletContextHandler)this.webAppContext, name, classname, parameters, ALL_URLS);
        for (ServletContextHandler ctx : this.defaultContexts.keySet()) {
            HttpServer.defineFilter(ctx, name, classname, parameters, ALL_URLS);
        }
        LOG.info("Added global filter '" + name + "' (class=" + classname + ")");
    }

    public static void defineFilter(ServletContextHandler handler, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        if (parameters != null) {
            holder.setInitParameters(parameters);
        }
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(31);
        fmap.setFilterName(name);
        handler.getServletHandler().addFilter(holder, fmap);
    }

    protected void addFilterPathMapping(String pathSpec, WebAppContext webAppCtx) {
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(31);
            webAppCtx.getServletHandler().addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public String getWebAppsPath(String appName) throws FileNotFoundException {
        return this.getWebAppsPath(this.appDir, appName);
    }

    protected String getWebAppsPath(String webapps, String appName) throws FileNotFoundException {
        URL url = this.getClass().getClassLoader().getResource(webapps + "/" + appName);
        if (url == null) {
            throw new FileNotFoundException(webapps + "/" + appName + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    @Deprecated
    public int getPort() {
        return ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
    }

    public InetSocketAddress getConnectorAddress(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        if (index > this.webServer.getConnectors().length) {
            return null;
        }
        ServerConnector c = (ServerConnector)this.webServer.getConnectors()[index];
        if (c.getLocalPort() == -1 || c.getLocalPort() == -2) {
            return null;
        }
        return new InetSocketAddress(c.getHost(), c.getLocalPort());
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    private void initSpnego(Configuration conf, String hostName, String usernameConfKey, String keytabConfKey, String kerberosNameRuleKey, String signatureSecretKeyFileKey) throws IOException {
        String signatureSecretKeyFile;
        String kerberosNameRule;
        String httpKeytab;
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = this.getOrEmptyString(conf, usernameConfKey);
        if (!principalInConf.isEmpty()) {
            params.put(HTTP_SPNEGO_AUTHENTICATION_PRINCIPAL_SUFFIX, SecurityUtil.getServerPrincipal((String)principalInConf, (String)hostName));
        }
        if (!(httpKeytab = this.getOrEmptyString(conf, keytabConfKey)).isEmpty()) {
            params.put(HTTP_SPNEGO_AUTHENTICATION_KEYTAB_SUFFIX, httpKeytab);
        }
        if (!(kerberosNameRule = this.getOrEmptyString(conf, kerberosNameRuleKey)).isEmpty()) {
            params.put(HTTP_SPNEGO_AUTHENTICATION_KRB_NAME_SUFFIX, kerberosNameRule);
        }
        if (!(signatureSecretKeyFile = this.getOrEmptyString(conf, signatureSecretKeyFileKey)).isEmpty()) {
            params.put(HTTP_AUTHENTICATION_SIGNATURE_SECRET_FILE_SUFFIX, signatureSecretKeyFile);
        }
        params.put("type", "kerberos");
        if (this.isMissing((String)params.get(HTTP_SPNEGO_AUTHENTICATION_PRINCIPAL_SUFFIX)) || this.isMissing((String)params.get(HTTP_SPNEGO_AUTHENTICATION_KEYTAB_SUFFIX))) {
            throw new IllegalArgumentException(usernameConfKey + " and " + keytabConfKey + " are both required in the configuration to enable SPNEGO/Kerberos authentication for the Web UI");
        }
        if (conf.getBoolean(HTTP_SPNEGO_AUTHENTICATION_PROXYUSER_ENABLE_KEY, false)) {
            for (Map.Entry proxyEntry : conf.getPropsWithPrefix("hadoop.proxyuser").entrySet()) {
                params.put("proxyuser" + (String)proxyEntry.getKey(), (String)proxyEntry.getValue());
            }
            this.addGlobalFilter(SPNEGO_PROXYUSER_FILTER, ProxyUserAuthenticationFilter.class.getName(), params);
        } else {
            this.addGlobalFilter(SPNEGO_FILTER, AuthenticationFilter.class.getName(), params);
        }
    }

    private boolean isMissing(String value) {
        if (null == value) {
            return true;
        }
        return value.trim().isEmpty();
    }

    private String getOrEmptyString(Configuration conf, String key) {
        if (null == key) {
            return EMPTY_STRING;
        }
        String value = conf.get(key.trim());
        return null == value ? EMPTY_STRING : value;
    }

    public void start() throws IOException {
        try {
            try {
                this.openListeners();
                this.webServer.start();
            }
            catch (IOException ex) {
                LOG.info("HttpServer.start() threw a non Bind IOException", (Throwable)ex);
                throw ex;
            }
            catch (MultiException ex) {
                LOG.info("HttpServer.start() threw a MultiException", (Throwable)ex);
                throw ex;
            }
            Handler[] handlers = this.webServer.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!handlers[i].isFailed()) continue;
                throw new IOException("Problem in starting http server. Server handlers failed");
            }
            Throwable unavailableException = this.webAppContext.getUnavailableException();
            if (unavailableException != null) {
                this.webServer.stop();
                throw new IOException("Unable to initialize WebAppContext", unavailableException);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted while starting HTTP server").initCause(e);
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    private void loadListeners() {
        for (ListenerInfo li : this.listeners) {
            this.webServer.addConnector((Connector)li.listener);
        }
    }

    void openListeners() throws Exception {
        block2: for (ListenerInfo li : this.listeners) {
            ServerConnector listener = li.listener;
            if (!li.isManaged || li.listener.getLocalPort() != -1 && li.listener.getLocalPort() != -2) continue;
            int port = listener.getPort();
            while (true) {
                try {
                    listener.close();
                    listener.open();
                    LOG.info("Jetty bound to port " + listener.getLocalPort());
                    continue block2;
                }
                catch (IOException ex) {
                    if (!(ex instanceof BindException) && !(ex.getCause() instanceof BindException)) {
                        throw ex;
                    }
                    if (port == 0 || !this.findPort) {
                        BindException be = new BindException("Port in use: " + listener.getHost() + ":" + listener.getPort());
                        be.initCause(ex);
                        throw be;
                    }
                    listener.setPort(++port);
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
    }

    public void stop() throws Exception {
        MultiException exception = null;
        for (ListenerInfo li : this.listeners) {
            if (!li.isManaged) continue;
            try {
                li.listener.close();
            }
            catch (Exception e) {
                LOG.error("Error while stopping listener for webapp" + this.webAppContext.getDisplayName(), (Throwable)e);
                exception = this.addMultiException(exception, e);
            }
        }
        try {
            this.webAppContext.clearAttributes();
            this.webAppContext.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web app context for webapp " + this.webAppContext.getDisplayName(), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web server for webapp " + this.webAppContext.getDisplayName(), (Throwable)e);
            exception = this.addMultiException(exception, e);
        }
        if (exception != null) {
            exception.ifExceptionThrow();
        }
    }

    private MultiException addMultiException(MultiException exception, Exception e) {
        if (exception == null) {
            exception = new MultiException();
        }
        exception.add((Throwable)e);
        return exception;
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public boolean isAlive() {
        return this.webServer != null && this.webServer.isStarted();
    }

    public String toString() {
        if (this.listeners.isEmpty()) {
            return "Inactive HttpServer";
        }
        StringBuilder sb = new StringBuilder("HttpServer (").append(this.isAlive() ? STATE_DESCRIPTION_ALIVE : STATE_DESCRIPTION_NOT_LIVE).append("), listening at:");
        for (ListenerInfo li : this.listeners) {
            ServerConnector l = li.listener;
            sb.append(l.getHost()).append(":").append(l.getPort()).append("/,");
        }
        return sb.toString();
    }

    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        AccessControlList acl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        return HttpServer.hasAdministratorAccess(conf, acl, request, response);
    }

    public static boolean hasAdministratorAccess(Configuration conf, AccessControlList acl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (acl != null && !HttpServer.userHasAdministratorAccess(acl, remoteUser)) {
            response.sendError(403, "User " + remoteUser + " is unauthorized to access this page.");
            return false;
        }
        return true;
    }

    public static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        return HttpServer.userHasAdministratorAccess(adminsAcl, remoteUser);
    }

    public static boolean userHasAdministratorAccess(AccessControlList acl, String remoteUser) {
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        return acl != null && acl.isUserAllowed(remoteUserUGI);
    }

    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;

        public void init(FilterConfig config) throws ServletException {
            this.config = config;
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            chain.doFilter((ServletRequest)quoted, (ServletResponse)httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ServletContext context = this.config.getServletContext();
            return context.getMimeType(path);
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map raw = this.rawRequest.getParameterMap();
                for (Map.Entry item : raw.entrySet()) {
                    String[] rawValue = (String[])item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars((String)item.getKey()), cookedValue);
                }
                return result;
            }

            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            response.setContentType("text/plain; charset=UTF-8");
            try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
                Threads.printThreadInfo((PrintStream)out, (String)HttpServer.EMPTY_STRING);
                out.flush();
            }
            ReflectionUtils.logThreadInfo((Logger)LOG, (String)"jsp requested", (long)1L);
        }
    }

    public static class Builder {
        private ArrayList<URI> endpoints = Lists.newArrayList();
        private Configuration conf;
        private String[] pathSpecs;
        private AccessControlList adminsAcl;
        private boolean securityEnabled = false;
        private String usernameConfKey;
        private String keytabConfKey;
        private boolean needsClientAuth;
        private String includeCiphers;
        private String excludeCiphers;
        private String includeProtocols;
        private String excludeProtocols;
        private String hostName;
        private String appDir = "webapps";
        private String logDir;
        private boolean findPort;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String keyPassword;
        private String kerberosNameRulesKey;
        private String signatureSecretFileKey;
        @Deprecated
        private String name;
        @Deprecated
        private String bindAddress;
        @Deprecated
        private int port = -1;

        public Builder addEndpoint(URI endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder trustStore(String location, String password, String type) {
            this.trustStore = location;
            this.trustStorePassword = password;
            this.trustStoreType = type;
            return this;
        }

        public Builder keyStore(String location, String password, String type) {
            this.keyStore = location;
            this.keyStorePassword = password;
            this.keyStoreType = type;
            return this;
        }

        public Builder keyPassword(String password) {
            this.keyPassword = password;
            return this;
        }

        public Builder needsClientAuth(boolean value) {
            this.needsClientAuth = value;
            return this;
        }

        @Deprecated
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Deprecated
        public Builder setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        @Deprecated
        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setFindPort(boolean findPort) {
            this.findPort = findPort;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setPathSpec(String[] pathSpec) {
            this.pathSpecs = pathSpec;
            return this;
        }

        public Builder setACL(AccessControlList acl) {
            this.adminsAcl = acl;
            return this;
        }

        public Builder setSecurityEnabled(boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
            return this;
        }

        public Builder setUsernameConfKey(String usernameConfKey) {
            this.usernameConfKey = usernameConfKey;
            return this;
        }

        public Builder setKeytabConfKey(String keytabConfKey) {
            this.keytabConfKey = keytabConfKey;
            return this;
        }

        public Builder setKerberosNameRulesKey(String kerberosNameRulesKey) {
            this.kerberosNameRulesKey = kerberosNameRulesKey;
            return this;
        }

        public Builder setSignatureSecretFileKey(String signatureSecretFileKey) {
            this.signatureSecretFileKey = signatureSecretFileKey;
            return this;
        }

        public Builder setAppDir(String appDir) {
            this.appDir = appDir;
            return this;
        }

        public Builder setLogDir(String logDir) {
            this.logDir = logDir;
            return this;
        }

        @Deprecated
        public void excludeCiphers(String excludeCiphers) {
            this.excludeCiphers = excludeCiphers;
        }

        public Builder setExcludeCiphers(String excludeCiphers) {
            this.excludeCiphers = excludeCiphers;
            return this;
        }

        public Builder setIncludeCiphers(String includeCiphers) {
            this.includeCiphers = includeCiphers;
            return this;
        }

        public Builder setIncludeProtocols(String includeProtocols) {
            this.includeProtocols = includeProtocols;
            return this;
        }

        public Builder setExcludeProtocols(String excludeProtocols) {
            this.excludeProtocols = excludeProtocols;
            return this;
        }

        public HttpServer build() throws IOException {
            if (this.name == null) {
                throw new HadoopIllegalArgumentException("name is not set");
            }
            if (this.bindAddress != null && this.port != -1) {
                try {
                    this.endpoints.add(0, new URI("http", HttpServer.EMPTY_STRING, this.bindAddress, this.port, HttpServer.EMPTY_STRING, HttpServer.EMPTY_STRING, HttpServer.EMPTY_STRING));
                }
                catch (URISyntaxException e) {
                    throw new HadoopIllegalArgumentException("Invalid endpoint: " + e);
                }
            }
            if (this.endpoints.isEmpty()) {
                throw new HadoopIllegalArgumentException("No endpoints specified");
            }
            if (this.hostName == null) {
                this.hostName = this.endpoints.get(0).getHost();
            }
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            HttpServer server = new HttpServer(this);
            for (URI ep : this.endpoints) {
                ServerConnector listener = null;
                String scheme = ep.getScheme();
                HttpConfiguration httpConfig = new HttpConfiguration();
                httpConfig.setSecureScheme("https");
                httpConfig.setHeaderCacheSize(65534);
                httpConfig.setResponseHeaderSize(65534);
                httpConfig.setRequestHeaderSize(65534);
                httpConfig.setSendServerVersion(false);
                if ("http".equals(scheme)) {
                    listener = new ServerConnector(server.webServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
                } else if ("https".equals(scheme)) {
                    HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
                    httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                    SslContextFactory.Server sslCtxFactory = new SslContextFactory.Server();
                    sslCtxFactory.setNeedClientAuth(this.needsClientAuth);
                    sslCtxFactory.setKeyManagerPassword(this.keyPassword);
                    if (this.keyStore != null) {
                        sslCtxFactory.setKeyStorePath(this.keyStore);
                        sslCtxFactory.setKeyStoreType(this.keyStoreType);
                        sslCtxFactory.setKeyStorePassword(this.keyStorePassword);
                    }
                    if (this.trustStore != null) {
                        sslCtxFactory.setTrustStorePath(this.trustStore);
                        sslCtxFactory.setTrustStoreType(this.trustStoreType);
                        sslCtxFactory.setTrustStorePassword(this.trustStorePassword);
                    }
                    if (this.includeProtocols != null && !this.includeProtocols.trim().isEmpty()) {
                        sslCtxFactory.setIncludeProtocols(StringUtils.getTrimmedStrings((String)this.includeProtocols));
                        LOG.debug("Included TLS Protocol List:" + this.includeProtocols);
                    }
                    if (this.excludeProtocols != null && !this.excludeProtocols.trim().isEmpty()) {
                        sslCtxFactory.setExcludeProtocols(StringUtils.getTrimmedStrings((String)this.excludeProtocols));
                        LOG.debug("Excluded TLS Protocol List:" + this.excludeProtocols);
                    }
                    if (this.includeCiphers != null && !this.includeCiphers.trim().isEmpty()) {
                        sslCtxFactory.setIncludeCipherSuites(StringUtils.getTrimmedStrings((String)this.includeCiphers));
                        LOG.debug("Included SSL Cipher List:" + this.includeCiphers);
                    }
                    if (this.excludeCiphers != null && !this.excludeCiphers.trim().isEmpty()) {
                        sslCtxFactory.setExcludeCipherSuites(StringUtils.getTrimmedStrings((String)this.excludeCiphers));
                        LOG.debug("Excluded SSL Cipher List:" + this.excludeCiphers);
                    }
                    listener = new ServerConnector(server.webServer, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslCtxFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpsConfig)});
                } else {
                    throw new HadoopIllegalArgumentException("unknown scheme for endpoint:" + ep);
                }
                listener.setAcceptQueueSize(128);
                if (Shell.WINDOWS) {
                    listener.setReuseAddress(false);
                }
                listener.setHost(ep.getHost());
                listener.setPort(ep.getPort() == -1 ? 0 : ep.getPort());
                server.addManagedListener(listener);
            }
            server.loadListeners();
            return server;
        }
    }

    private static final class ListenerInfo {
        private final boolean isManaged;
        private final ServerConnector listener;

        private ListenerInfo(boolean isManaged, ServerConnector listener) {
            this.isManaged = isManaged;
            this.listener = listener;
        }
    }
}

