/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifier;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestLowLatencySpaceQuotas {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLowLatencySpaceQuotas.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;
    private Connection conn;
    private Admin admin;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.period", 120000);
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.delay", 120000);
        conf.setInt("hbase.master.quotas.snapshot.chore.period", 120000);
        conf.setInt("hbase.master.quotas.snapshot.chore.delay", 120000);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 5000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        this.conn = TEST_UTIL.getConnection();
        this.admin = TEST_UTIL.getAdmin();
        this.helper.waitForQuotaTable(this.conn);
    }

    @Test
    public void testFlushes() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long initialSize = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        this.admin.flush(tn);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x200000L;
            }
        });
    }

    @Test
    public void testMajorCompaction() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long sizePerBatch = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        this.admin.flush(tn);
        this.helper.writeData(tn, 0x200000L);
        this.admin.flush(tn);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x400000L;
            }
        });
        this.admin.majorCompact(tn);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 0x200000L && snapshot.getUsage() <= 0x400000L;
            }
        });
    }

    @Test
    public void testMinorCompaction() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long sizePerBatch = 0x200000L;
        long numBatches = 6L;
        for (long i = 0L; i < 6L; ++i) {
            this.helper.writeData(tn, 0x200000L);
            this.admin.flush(tn);
        }
        HRegion region = (HRegion)Iterables.getOnlyElement(TEST_UTIL.getHBaseCluster().getRegions(tn));
        final long numFiles = this.getNumHFilesForRegion(region);
        Assert.assertEquals((long)6L, (long)numFiles);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= numFiles * 0x200000L;
            }
        });
        TEST_UTIL.compact(tn, false);
        final long numFilesAfterMinorCompaction = this.getNumHFilesForRegion(region);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= numFilesAfterMinorCompaction * 0x200000L && snapshot.getUsage() <= (numFilesAfterMinorCompaction + 1L) * 0x200000L;
            }
        });
    }

    private long getNumHFilesForRegion(HRegion region) {
        return region.getStores().stream().mapToLong(s -> s.getNumHFiles()).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkLoading() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        this.admin.compactionSwitch(false, this.admin.getRegionServers().stream().map(ServerName::toString).collect(Collectors.toList()));
        ClientServiceCallable<Void> callable = this.helper.generateFileToLoad(tn, 3, 550);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        FileStatus[] files = fs.listStatus(new Path(fs.getHomeDirectory(), this.testName.getMethodName() + "_files"));
        long totalSize = 0L;
        for (FileStatus file : files) {
            Assert.assertTrue((String)("Expected the file, " + file.getPath() + ",  length to be larger than 25KB, but was " + file.getLen()), (file.getLen() > 25600L ? 1 : 0) != 0);
            totalSize += file.getLen();
        }
        ClusterConnection clusterConn = (ClusterConnection)this.conn;
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TEST_UTIL.getConfiguration(), clusterConn.getConnectionConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        caller.callWithRetries(callable, Integer.MAX_VALUE);
        final long finalTotalSize = totalSize;
        try {
            TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

                @Override
                boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                    return snapshot.getUsage() >= finalTotalSize;
                }
            });
        }
        finally {
            this.admin.compactionSwitch(true, this.admin.getRegionServers().stream().map(ServerName::toString).collect(Collectors.toList()));
        }
    }

    @Test
    public void testSnapshotSizes() throws Exception {
        TableName tn = this.helper.createTableWithRegions(1);
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        this.admin.setQuota(settings);
        long sizePerBatch = 0x200000L;
        this.helper.writeData(tn, 0x200000L);
        this.admin.flush(tn);
        String snapshot1 = "snapshot1";
        this.admin.snapshot("snapshot1", tn, SnapshotType.SKIPFLUSH);
        Region region = (Region)Iterables.getOnlyElement(TEST_UTIL.getHBaseCluster().getRegions(tn));
        List stores = region.getStores();
        long summer = 0L;
        for (Store store : stores) {
            summer += store.getStorefilesSize();
        }
        final long storeFileSize = summer;
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == storeFileSize;
            }
        });
        FileArchiverNotifier notifier = TEST_UTIL.getHBaseCluster().getMaster().getSnapshotQuotaObserverChore().getNotifierForTable(tn);
        notifier.computeAndStoreSnapshotSizes(Collections.singletonList("snapshot1"));
        TEST_UTIL.compact(tn, true);
        TEST_UTIL.waitFor(30000L, 500L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() >= 2L * storeFileSize;
            }
        });
        try (Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);){
            Result r = quotaTable.get(QuotaTableUtil.makeGetForSnapshotSize((TableName)tn, (String)"snapshot1"));
            Assert.assertTrue((String)"Expected a non-null, non-empty Result", (r != null && !r.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)r.advance());
            Assert.assertEquals((String)"The snapshot's size should be the same as the origin store file", (long)storeFileSize, (long)QuotaTableUtil.parseSnapshotSize((Cell)r.current()));
            r = quotaTable.get(QuotaTableUtil.createGetNamespaceSnapshotSize((String)tn.getNamespaceAsString()));
            Assert.assertTrue((String)"Expected a non-null, non-empty Result", (r != null && !r.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)r.advance());
            Assert.assertEquals((String)"The snapshot's size should be the same as the origin store file", (long)storeFileSize, (long)QuotaTableUtil.parseSnapshotSize((Cell)r.current()));
        }
    }
}

