/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictMatchExternalViewVerifier
extends ZkHelixClusterVerifier {
    private static Logger LOG = LoggerFactory.getLogger(StrictMatchExternalViewVerifier.class);
    private final Set<String> _resources;
    private final Set<String> _expectLiveInstances;
    private final boolean _isDeactivatedNodeAware;

    @Deprecated
    public StrictMatchExternalViewVerifier(String zkAddr, String clusterName, Set<String> resources, Set<String> expectLiveInstances) {
        this(zkAddr, clusterName, resources, expectLiveInstances, false, 0);
    }

    @Deprecated
    public StrictMatchExternalViewVerifier(RealmAwareZkClient zkClient, String clusterName, Set<String> resources, Set<String> expectLiveInstances) {
        super(zkClient, clusterName, true, 0);
        this._resources = resources == null ? new HashSet<String>() : new HashSet<String>(resources);
        this._expectLiveInstances = expectLiveInstances == null ? new HashSet<String>() : new HashSet<String>(expectLiveInstances);
        this._isDeactivatedNodeAware = false;
    }

    @Deprecated
    private StrictMatchExternalViewVerifier(String zkAddr, String clusterName, Set<String> resources, Set<String> expectLiveInstances, boolean isDeactivatedNodeAware, int waitTillVerify) {
        super(zkAddr, clusterName, waitTillVerify);
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
        this._isDeactivatedNodeAware = isDeactivatedNodeAware;
    }

    private StrictMatchExternalViewVerifier(RealmAwareZkClient zkClient, String clusterName, Set<String> resources, Set<String> expectLiveInstances, boolean isDeactivatedNodeAware, int waitPeriodTillVerify, boolean usesExternalZkClient) {
        super(zkClient, clusterName, usesExternalZkClient, 0);
        this._resources = resources == null ? new HashSet<String>() : new HashSet<String>(resources);
        this._expectLiveInstances = expectLiveInstances == null ? new HashSet<String>() : new HashSet<String>(expectLiveInstances);
        this._isDeactivatedNodeAware = isDeactivatedNodeAware;
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        this.waitTillVerify();
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        if (this._resources != null && !this._resources.isEmpty()) {
            for (String resource : this._resources) {
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(resource), true, false, false));
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalView(resource), true, false, false));
            }
        } else {
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(), false, true, true));
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalViews(), false, true, true));
        }
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected boolean verifyState() {
        try {
            Set<String> actualLiveNodes;
            PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
            ResourceControllerDataProvider cache = new ResourceControllerDataProvider();
            cache.refresh(this._accessor);
            HashMap<String, IdealState> idealStates = new HashMap<String, IdealState>(cache.getIdealStates());
            Iterator it = idealStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (!((IdealState)pair.getValue()).getStateModelDefRef().equals("Task")) continue;
                it.remove();
            }
            if (this._expectLiveInstances != null && !this._expectLiveInstances.isEmpty() && !this._expectLiveInstances.equals(actualLiveNodes = cache.getLiveInstances().keySet())) {
                return false;
            }
            Map<String, Object> extViews = this._accessor.getChildValuesMap(keyBuilder.externalViews(), true);
            if (extViews == null) {
                extViews = Collections.emptyMap();
            }
            if (this._resources != null && !this._resources.isEmpty()) {
                idealStates.keySet().retainAll(this._resources);
                extViews.keySet().retainAll(this._resources);
            }
            for (String resource : extViews.keySet()) {
                if (idealStates.containsKey(resource)) continue;
                idealStates.put(resource, new IdealState(resource));
            }
            for (String resourceName : idealStates.keySet()) {
                ExternalView extView = (ExternalView)extViews.get(resourceName);
                IdealState idealState = (IdealState)idealStates.get(resourceName);
                if (extView == null) {
                    if (idealState.isExternalViewDisabled()) continue;
                    LOG.debug("externalView for " + resourceName + " is not available");
                    return false;
                }
                boolean result = this.verifyExternalView(cache, extView, idealState);
                if (result) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("exception in verification", (Throwable)e);
            return false;
        }
    }

    private boolean verifyExternalView(ResourceControllerDataProvider dataCache, ExternalView externalView, IdealState idealState) {
        Map<String, Map<String, String>> idealPartitionState;
        Map<String, Map<String, String>> mappingInExtview = externalView.getRecord().getMapFields();
        switch (idealState.getRebalanceMode()) {
            case FULL_AUTO: {
                ClusterConfig clusterConfig = new ConfigAccessor(this._zkClient).getClusterConfig(dataCache.getClusterName());
                if (!clusterConfig.isPersistBestPossibleAssignment().booleanValue() && !clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
                    throw new HelixException(String.format("Full-Auto IdealState verifier requires ClusterConfig.PERSIST_BEST_POSSIBLE_ASSIGNMENT or ClusterConfig.PERSIST_INTERMEDIATE_ASSIGNMENT is enabled.", new Object[0]));
                }
                for (String partition : idealState.getPartitionSet()) {
                    if (idealState.getPreferenceList(partition) != null && !idealState.getPreferenceList(partition).isEmpty()) continue;
                    return false;
                }
                idealPartitionState = this.computeIdealPartitionState(dataCache, idealState);
                break;
            }
            case SEMI_AUTO: 
            case USER_DEFINED: {
                idealPartitionState = this.computeIdealPartitionState(dataCache, idealState);
                break;
            }
            case CUSTOMIZED: {
                idealPartitionState = idealState.getRecord().getMapFields();
                break;
            }
            default: {
                return true;
            }
        }
        return mappingInExtview.equals(idealPartitionState);
    }

    private Map<String, Map<String, String>> computeIdealPartitionState(ResourceControllerDataProvider cache, IdealState idealState) {
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        HashMap<String, Map<String, String>> idealPartitionState = new HashMap<String, Map<String, String>>();
        for (String partition : idealState.getPartitionSet()) {
            List<String> preferenceList = AbstractRebalancer.getPreferenceList(new Partition(partition), idealState, cache.getEnabledLiveInstances());
            Map<String, String> idealMapping = this._isDeactivatedNodeAware ? HelixUtil.computeIdealMapping(preferenceList, stateModelDef, cache.getLiveInstances().keySet(), cache.getDisabledInstancesForPartition(idealState.getResourceName(), partition)) : HelixUtil.computeIdealMapping(preferenceList, stateModelDef, cache.getEnabledLiveInstances(), Collections.emptySet());
            idealPartitionState.put(partition, idealMapping);
        }
        return idealPartitionState;
    }

    public String toString() {
        String verifierName = this.getClass().getSimpleName();
        return String.format("%s(%s@%s@resources[%s])", verifierName, this._clusterName, this._zkClient.getServers(), this._resources != null ? Arrays.toString(this._resources.toArray()) : "");
    }

    @Override
    public void finalize() {
        this.close();
    }

    public static class Builder
    extends ZkHelixClusterVerifier.Builder<Builder> {
        private final String _clusterName;
        private Set<String> _resources;
        private Set<String> _expectLiveInstances;
        private RealmAwareZkClient _zkClient;
        private boolean _isDeactivatedNodeAware = false;
        private boolean _usesExternalZkClient = false;

        public StrictMatchExternalViewVerifier build() {
            if (this._clusterName == null) {
                throw new IllegalArgumentException("Cluster name is missing!");
            }
            if (this._zkClient != null) {
                return new StrictMatchExternalViewVerifier(this._zkClient, this._clusterName, this._resources, this._expectLiveInstances, this._isDeactivatedNodeAware, this._waitPeriodTillVerify, this._usesExternalZkClient);
            }
            if (this._realmAwareZkConnectionConfig == null || this._realmAwareZkClientConfig == null) {
                return new StrictMatchExternalViewVerifier(this._zkAddress, this._clusterName, this._resources, this._expectLiveInstances, this._isDeactivatedNodeAware, this._waitPeriodTillVerify);
            }
            this.validate();
            return new StrictMatchExternalViewVerifier(this.createZkClient(RealmAwareZkClient.RealmMode.SINGLE_REALM, this._realmAwareZkConnectionConfig, this._realmAwareZkClientConfig, this._zkAddress), this._clusterName, this._resources, this._expectLiveInstances, this._isDeactivatedNodeAware, this._waitPeriodTillVerify, this._usesExternalZkClient);
        }

        public Builder(String clusterName) {
            this._clusterName = clusterName;
        }

        @Override
        public String getClusterName() {
            return this._clusterName;
        }

        public Set<String> getResources() {
            return this._resources;
        }

        public Builder setResources(Set<String> resources) {
            this._resources = resources;
            return this;
        }

        public Set<String> getExpectLiveInstances() {
            return this._expectLiveInstances;
        }

        public Builder setExpectLiveInstances(Set<String> expectLiveInstances) {
            this._expectLiveInstances = expectLiveInstances;
            return this;
        }

        public String getZkAddress() {
            return this._zkAddress;
        }

        @Deprecated
        public Builder setZkClient(RealmAwareZkClient zkClient) {
            this._zkClient = zkClient;
            this._usesExternalZkClient = true;
            return this;
        }

        public boolean getDeactivatedNodeAwareness() {
            return this._isDeactivatedNodeAware;
        }

        public Builder setDeactivatedNodeAwareness(boolean isDeactivatedNodeAware) {
            this._isDeactivatedNodeAware = isDeactivatedNodeAware;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!this._clusterName.equals(this._realmAwareZkConnectionConfig.getZkRealmShardingKey())) {
                throw new IllegalArgumentException("StrictMatchExternalViewVerifier: Cluster name: " + this._clusterName + " and ZK realm sharding key: " + this._realmAwareZkConnectionConfig.getZkRealmShardingKey() + " do not match!");
            }
        }
    }
}

