--! qt:dataset:src
set hive.fetch.task.conversion=more;

DESCRIBE FUNCTION instr;
DESCRIBE FUNCTION EXTENDED instr;

EXPLAIN
SELECT instr('abcd', 'abc'),
       instr('abcabc', 'ccc'),
       instr(123, '23'),
       instr(123, 23),
       instr(TRUE, 1),
       instr(FALSE, 1),
       instr('12345', CAST('2' AS TINYINT)),
       instr(CAST('12345' AS SMALLINT), '34'),
       instr(CAST('123456789012' AS BIGINT), '456'),
       instr(CAST(1.25 AS FLOAT), '.25'),
       instr(CAST(16.0 AS DOUBLE), '.0'),
       instr(null, 'abc'),
       instr('abcd', null),
       instr('abcdabcd', 'abc', 1),
       instr('abcdabcd', 'abc', 2),
       instr('abcdabcd', 'abc', 5),
       instr('abcdabcd', 'abc', 6),
       instr('abcdabcd', 'abc', -1),
       instr('abcdabcd', 'abc', -4),
       instr('abcdabcd', 'abc', -5),
       instr('abcdabcd', 'abc', 1, 1),
       instr('abcdabcd', 'abc', 1, 2),
       instr('abcdabcd', 'abc', 1, 3),
       instr('abcdabcd', 'abc', 2, 1),
       instr('abcdabcd', 'abc', 2, 2),
       instr('abcdabcd', 'abc', 5, 2),
       instr('abcdabcd', 'abc', -1, 2),
       instr('abcdabcd', 'abc', -4, 2),
       instr('abcdabcd', 'abc', -5, 2),
       instr('abcdabcd', 'abc', 1, null),
       instr('abcdabcd', 'abc', null, 1),
       instr('aaa', 'a', 3, 1),
       instr('aaa', 'a', 3, 2)
FROM src tablesample (1 rows);

SELECT instr('abcd', 'abc'),
       instr('abcabc', 'ccc'),
       instr(123, '23'),
       instr(123, 23),
       instr(TRUE, 1),
       instr(FALSE, 1),
       instr('12345', CAST('2' AS TINYINT)),
       instr(CAST('12345' AS SMALLINT), '34'),
       instr(CAST('123456789012' AS BIGINT), '456'),
       instr(CAST(1.25 AS FLOAT), '.25'),
       instr(CAST(16.0 AS DOUBLE), '.0'),
       instr(null, 'abc'),
       instr('abcd', null),
       instr('abcdabcd', 'abc', 1),
       instr('abcdabcd', 'abc', 2),
       instr('abcdabcd', 'abc', 5),
       instr('abcdabcd', 'abc', 6),
       instr('abcdabcd', 'abc', -1),
       instr('abcdabcd', 'abc', -4),
       instr('abcdabcd', 'abc', -5),
       instr('abcdabcd', 'abc', 1, 1),
       instr('abcdabcd', 'abc', 1, 2),
       instr('abcdabcd', 'abc', 1, 3),
       instr('abcdabcd', 'abc', 2, 1),
       instr('abcdabcd', 'abc', 2, 2),
       instr('abcdabcd', 'abc', 5, 2),
       instr('abcdabcd', 'abc', -1, 2),
       instr('abcdabcd', 'abc', -4, 2),
       instr('abcdabcd', 'abc', -5, 2),
       instr('abcdabcd', 'abc', 1, null),
       instr('abcdabcd', 'abc', null, 1),
       instr('aaa', 'a', 3, 1),
       instr('aaa', 'a', 3, 2)
FROM src tablesample (1 rows);
