/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SecurityProtocols
implements Serializable {
    private static final long serialVersionUID = 3800474900139635836L;
    private Hashtable authProtocols = new Hashtable(5);
    private Hashtable privProtocols = new Hashtable(5);
    public static final String SECURITY_PROTOCOLS_PROPERTIES = "org.snmp4j.securityProtocols";
    private static final String SECURITY_PROTOCOLS_PROPERTIES_DEFAULT = "SecurityProtocols.properties";
    private static final LogAdapter logger = LogFactory.getLogger(SecurityProtocols.class);
    private static SecurityProtocols instance = null;
    private int maxAuthDigestLength = 0;
    private int maxPrivDecryptParamsLength = 0;

    protected SecurityProtocols() {
    }

    public static SecurityProtocols getInstance() {
        if (instance == null) {
            instance = new SecurityProtocols();
        }
        return instance;
    }

    public static void setSecurityProtocols(SecurityProtocols securityProtocols) {
        instance = securityProtocols;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addDefaultProtocols() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String string;
            InputStream inputStream = SecurityProtocols.class.getResourceAsStream(string = System.getProperty(SECURITY_PROTOCOLS_PROPERTIES, SECURITY_PROTOCOLS_PROPERTIES_DEFAULT));
            if (inputStream == null) {
                throw new InternalError("Could not read '" + string + "' from classpath!");
            }
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Object obj = clazz.newInstance();
                        if (obj instanceof AuthenticationProtocol) {
                            this.addAuthenticationProtocol((AuthenticationProtocol)obj);
                            continue;
                        }
                        if (obj instanceof PrivacyProtocol) {
                            this.addPrivacyProtocol((PrivacyProtocol)obj);
                            continue;
                        }
                        logger.error("Failed to register security protocol because it does not implement required interfaces: " + string2);
                    }
                    catch (Exception exception) {
                        logger.error(exception);
                        throw new InternalError(exception.toString());
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                String string3 = "Could not read '" + string + "': " + iOException.getMessage();
                logger.error(string3);
                throw new InternalError(string3);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                }
            }
        }
        this.addAuthenticationProtocol(new AuthMD5());
        this.addAuthenticationProtocol(new AuthSHA());
        this.addPrivacyProtocol(new PrivDES());
        this.addPrivacyProtocol(new PrivAES128());
        this.addPrivacyProtocol(new PrivAES192());
        this.addPrivacyProtocol(new PrivAES256());
    }

    public synchronized void addAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        if (this.authProtocols.get(authenticationProtocol.getID()) == null) {
            this.authProtocols.put(authenticationProtocol.getID(), authenticationProtocol);
            if (authenticationProtocol.getDigestLength() > this.maxAuthDigestLength) {
                this.maxAuthDigestLength = authenticationProtocol.getDigestLength();
            }
        }
    }

    public AuthenticationProtocol getAuthenticationProtocol(OID oID) {
        if (oID == null) {
            return null;
        }
        return (AuthenticationProtocol)this.authProtocols.get(oID);
    }

    public void removeAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authProtocols.remove(authenticationProtocol.getID());
    }

    public synchronized void addPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        if (this.privProtocols.get(privacyProtocol.getID()) == null) {
            this.privProtocols.put(privacyProtocol.getID(), privacyProtocol);
            if (privacyProtocol.getDecryptParamsLength() > this.maxPrivDecryptParamsLength) {
                this.maxPrivDecryptParamsLength = privacyProtocol.getDecryptParamsLength();
            }
        }
    }

    public PrivacyProtocol getPrivacyProtocol(OID oID) {
        if (oID == null) {
            return null;
        }
        return (PrivacyProtocol)this.privProtocols.get(oID);
    }

    public void removePrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privProtocols.remove(privacyProtocol.getID());
    }

    public byte[] passwordToKey(OID oID, OctetString octetString, byte[] byArray) {
        AuthenticationProtocol authenticationProtocol = (AuthenticationProtocol)this.authProtocols.get(oID);
        if (authenticationProtocol == null) {
            return null;
        }
        return authenticationProtocol.passwordToKey(octetString, byArray);
    }

    public byte[] passwordToKey(OID oID, OID oID2, OctetString octetString, byte[] byArray) {
        AuthenticationProtocol authenticationProtocol = (AuthenticationProtocol)this.authProtocols.get(oID2);
        if (authenticationProtocol == null) {
            return null;
        }
        PrivacyProtocol privacyProtocol = (PrivacyProtocol)this.privProtocols.get(oID);
        if (privacyProtocol == null) {
            return null;
        }
        byte[] byArray2 = authenticationProtocol.passwordToKey(octetString, byArray);
        if (byArray2 == null) {
            return null;
        }
        if (byArray2.length >= privacyProtocol.getMinKeyLength()) {
            if (byArray2.length > privacyProtocol.getMaxKeyLength()) {
                byte[] byArray3 = new byte[privacyProtocol.getMaxKeyLength()];
                System.arraycopy(byArray2, 0, byArray3, 0, privacyProtocol.getMaxKeyLength());
                return byArray3;
            }
            return byArray2;
        }
        byte[] byArray4 = privacyProtocol.extendShortKey(byArray2, octetString, byArray, authenticationProtocol);
        return byArray4;
    }

    public int getMaxAuthDigestLength() {
        return this.maxAuthDigestLength;
    }

    public int getMaxPrivDecryptParamsLength() {
        return this.maxPrivDecryptParamsLength;
    }

    public byte[] truncateKey(byte[] byArray, int n) {
        byte[] byArray2 = new byte[Math.min(n, byArray.length)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

