/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula.function;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transforms.formula.function.FunctionExample;
import org.w3c.dom.Node;

public class FunctionDescription {
    public static final String XML_TAG = "function";
    public static final String CONST_TD = "</td>";
    private String category;
    private String name;
    private String description;
    private String syntax;
    private String returns;
    private String constraints;
    private String semantics;
    private List<FunctionExample> functionExamples;

    public FunctionDescription(String category, String name, String description, String syntax, String returns, String constraints, String semantics, List<FunctionExample> functionExamples) {
        this.category = category;
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.returns = returns;
        this.constraints = constraints;
        this.semantics = semantics;
        this.functionExamples = functionExamples;
    }

    public FunctionDescription(Node node) {
        this.category = XmlHandler.getTagValue((Node)node, (String)"category");
        this.name = XmlHandler.getTagValue((Node)node, (String)"name");
        this.description = XmlHandler.getTagValue((Node)node, (String)"description");
        this.syntax = XmlHandler.getTagValue((Node)node, (String)"syntax");
        this.returns = XmlHandler.getTagValue((Node)node, (String)"returns");
        this.constraints = XmlHandler.getTagValue((Node)node, (String)"constraints");
        this.semantics = XmlHandler.getTagValue((Node)node, (String)"semantics");
        this.functionExamples = new ArrayList<FunctionExample>();
        Node examplesNode = XmlHandler.getSubNode((Node)node, (String)"examples");
        int nrExamples = XmlHandler.countNodes((Node)examplesNode, (String)"example");
        for (int i = 0; i < nrExamples; ++i) {
            Node exampleNode = XmlHandler.getSubNodeByNr((Node)examplesNode, (String)"example", (int)i);
            this.functionExamples.add(new FunctionExample(exampleNode));
        }
    }

    public String getHtmlReport() {
        StringBuilder report = new StringBuilder(200);
        report.append("<H2>").append(this.name).append("</H2>").append(Const.CR);
        report.append("<b><u>Description:</u></b> ").append(this.description).append("<br>").append(Const.CR);
        if (!Utils.isEmpty((CharSequence)this.syntax)) {
            report.append("<b><u>Syntax:</u></b> <pre>").append(this.syntax).append("</pre><br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.returns)) {
            report.append("<b><u>Returns:</u></b>  ").append(this.returns).append("<br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.constraints)) {
            report.append("<b><u>Constraints:</u></b>  ").append(this.constraints).append("<br>").append(Const.CR);
        }
        if (!Utils.isEmpty((CharSequence)this.semantics)) {
            report.append("<b><u>Semantics:</u></b>  ").append(this.semantics).append("<br>").append(Const.CR);
        }
        if (!this.functionExamples.isEmpty()) {
            report.append(Const.CR);
            report.append("<br><b><u>Examples:</u></b><p>  ").append(Const.CR);
            report.append("<table border=\"1\">");
            report.append("<tr>");
            report.append("<th>Expression</th>");
            report.append("<th>Result</th>");
            report.append("<th>Comment</th>");
            report.append("</tr>");
            for (FunctionExample example : this.functionExamples) {
                report.append("<tr>");
                report.append("<td>").append(example.getExpression()).append(CONST_TD);
                report.append("<td>").append(example.getResult()).append(CONST_TD);
                if (!Utils.isEmpty((CharSequence)example.getComment())) {
                    report.append("<td>").append(example.getComment()).append(CONST_TD);
                }
                report.append("</tr>");
                report.append(Const.CR);
            }
            report.append("</table>");
        }
        return report.toString();
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getSyntax() {
        return this.syntax;
    }

    @Generated
    public String getReturns() {
        return this.returns;
    }

    @Generated
    public String getConstraints() {
        return this.constraints;
    }

    @Generated
    public String getSemantics() {
        return this.semantics;
    }

    @Generated
    public List<FunctionExample> getFunctionExamples() {
        return this.functionExamples;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @Generated
    public void setReturns(String returns) {
        this.returns = returns;
    }

    @Generated
    public void setConstraints(String constraints) {
        this.constraints = constraints;
    }

    @Generated
    public void setSemantics(String semantics) {
        this.semantics = semantics;
    }

    @Generated
    public void setFunctionExamples(List<FunctionExample> functionExamples) {
        this.functionExamples = functionExamples;
    }
}

