/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class MonitorInputStream
extends BufferedInputStream {
    private static final int EOF_CHAR = -1;
    private final AtomicLong count = new AtomicLong();
    private final AtomicBoolean closed = new AtomicBoolean();

    public MonitorInputStream(InputStream in) {
        super(in);
    }

    public MonitorInputStream(InputStream in, int bufferSize) {
        super(in, bufferSize);
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed()) {
            return 0;
        }
        return super.available();
    }

    @Override
    public void close() throws IOException {
        boolean alreadyClosed = this.closed.getAndSet(true);
        if (alreadyClosed) {
            return;
        }
        IOException exc = null;
        try {
            this.closeSuper();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected void closeSuper() throws IOException {
        super.close();
    }

    public long getCount() {
        return this.count.get();
    }

    private boolean isClosed() {
        return this.closed.get();
    }

    protected void onClose() throws IOException {
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int ch = super.read();
        if (ch != -1) {
            this.count.incrementAndGet();
        }
        return ch;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int numRead = super.read(buffer, offset, length);
        if (numRead != -1) {
            this.count.addAndGet(numRead);
        }
        return numRead;
    }
}

