/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import java.util.function.LongPredicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.MaxSSTableSizeWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class SSTableSplitter {
    private final SplittingCompactionTask task;

    public SSTableSplitter(ColumnFamilyStore cfs, LifecycleTransaction transaction, int sstableSizeInMB) {
        this.task = new SplittingCompactionTask(cfs, transaction, sstableSizeInMB);
    }

    public void split() {
        this.task.execute(ActiveCompactionsTracker.NOOP);
    }

    public static class SplitController
    extends CompactionController {
        public SplitController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MIN_VALUE);
        }

        @Override
        public LongPredicate getPurgeEvaluator(DecoratedKey key) {
            return time -> false;
        }
    }

    public static class SplittingCompactionTask
    extends CompactionTask {
        private final int sstableSizeInMiB;

        public SplittingCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction transaction, int sstableSizeInMB) {
            super(cfs, transaction, Integer.MIN_VALUE, false);
            this.sstableSizeInMiB = sstableSizeInMB;
            if (sstableSizeInMB <= 0) {
                throw new IllegalArgumentException("Invalid target size for SSTables, must be > 0 (got: " + sstableSizeInMB + ")");
            }
        }

        @Override
        protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
            return new SplitController(this.cfs);
        }

        @Override
        public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
            return new MaxSSTableSizeWriter(cfs, directories, txn, nonExpiredSSTables, (long)this.sstableSizeInMiB * 1024L * 1024L, 0, false);
        }

        @Override
        protected boolean partialCompactionsAcceptable() {
            return true;
        }
    }
}

