/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;

@ChannelHandler.Sharable
public class FrameEncoderCrc
extends FrameEncoder {
    static final int HEADER_LENGTH = 6;
    private static final int TRAILER_LENGTH = 4;
    public static final int HEADER_AND_TRAILER_LENGTH = 10;
    public static final FrameEncoderCrc instance = new FrameEncoderCrc();
    static final FrameEncoder.PayloadAllocator allocator = (isSelfContained, capacity) -> new FrameEncoder.Payload(isSelfContained, capacity, 6, 4);

    @Override
    public FrameEncoder.PayloadAllocator allocator() {
        return allocator;
    }

    static void writeHeader(ByteBuffer frame, boolean isSelfContained, int dataLength) {
        int header3b = dataLength;
        if (isSelfContained) {
            header3b |= 0x20000;
        }
        int crc = Crc.crc24(header3b, 3);
        FrameEncoderCrc.put3b(frame, 0, header3b);
        FrameEncoderCrc.put3b(frame, 3, crc);
    }

    private static void put3b(ByteBuffer frame, int index, int put3b) {
        frame.put(index, (byte)put3b);
        frame.put(index + 1, (byte)(put3b >>> 8));
        frame.put(index + 2, (byte)(put3b >>> 16));
    }

    @Override
    ByteBuf encode(boolean isSelfContained, ByteBuffer frame) {
        try {
            int frameLength = frame.remaining();
            int dataLength = frameLength - 10;
            if (dataLength >= 131072) {
                throw new IllegalArgumentException("Maximum payload size is 128KiB");
            }
            FrameEncoderCrc.writeHeader(frame, isSelfContained, dataLength);
            CRC32 crc = Crc.crc32();
            frame.position(6);
            frame.limit(dataLength + 6);
            crc.update(frame);
            int frameCrc = (int)crc.getValue();
            if (frame.order() == ByteOrder.BIG_ENDIAN) {
                frameCrc = Integer.reverseBytes(frameCrc);
            }
            frame.limit(frameLength);
            frame.putInt(frameLength - 4, frameCrc);
            frame.position(0);
            return GlobalBufferPoolAllocator.wrap(frame);
        }
        catch (Throwable t) {
            bufferPool.put(frame);
            throw t;
        }
    }
}

