/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.variables.IVariables;

public class Utils {
    public static int getDamerauLevenshteinDistance(String one, String two) {
        int oneLength = one == null ? 0 : one.length();
        int twoLength = two == null ? 0 : two.length();
        int oneTwoLength = oneLength + twoLength;
        if (StringUtils.isEmpty((CharSequence)one)) {
            if (StringUtils.isEmpty((CharSequence)two)) {
                return 0;
            }
            return twoLength;
        }
        if (StringUtils.isEmpty((CharSequence)two)) {
            return oneLength;
        }
        int[][] distancesMatrix = new int[oneLength + 2][twoLength + 2];
        distancesMatrix[0][0] = oneTwoLength;
        for (int x = 0; x <= oneLength; ++x) {
            distancesMatrix[x + 1][1] = x;
            distancesMatrix[x + 1][0] = oneTwoLength;
        }
        for (int y = 0; y <= twoLength; ++y) {
            distancesMatrix[1][y + 1] = y;
            distancesMatrix[0][y + 1] = oneTwoLength;
        }
        HashMap<Character, Integer> characterMap = new HashMap<Character, Integer>();
        for (int x = 1; x <= oneLength; ++x) {
            int tmpIndex = 0;
            for (int y = 1; y <= twoLength; ++y) {
                int distance;
                char charOne = one.charAt(x - 1);
                char charTwo = two.charAt(y - 1);
                int x1 = characterMap.getOrDefault(Character.valueOf(charTwo), 0);
                int y1 = tmpIndex;
                int n = distance = charOne == charTwo ? 0 : 1;
                if (distance == 0) {
                    tmpIndex = y;
                }
                distancesMatrix[x + 1][y + 1] = NumberUtils.min((int[])new int[]{distancesMatrix[x][y] + distance, distancesMatrix[x + 1][y] + 1, distancesMatrix[x][y + 1] + 1, distancesMatrix[x1][y1] + (x - x1 - 1) + 1 + (y - y1 - 1)});
            }
            characterMap.put(Character.valueOf(one.charAt(x - 1)), x);
        }
        return distancesMatrix[oneLength + 1][twoLength + 1];
    }

    public static boolean isEmpty(CharSequence val) {
        return val == null || val.length() == 0;
    }

    public static boolean isEmpty(CharSequence[] strings) {
        return strings == null || strings.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static String resolvePassword(IVariables variables, String password) {
        String resolvedPassword = variables.resolve(password);
        if (resolvedPassword != null) {
            return Encr.decryptPasswordOptionallyEncrypted(resolvedPassword);
        }
        return resolvedPassword;
    }

    public static String[][] normalizeArrays(int normalizeToLength, String[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        String[][] rtn = new String[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            String[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    String[] newArray = new String[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new String[normalizeToLength];
        }
        return rtn;
    }

    public static long[][] normalizeArrays(int normalizeToLength, long[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        long[][] rtn = new long[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            long[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    long[] newArray = new long[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new long[normalizeToLength];
        }
        return rtn;
    }

    public static int[][] normalizeArrays(int normalizeToLength, int[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        int[][] rtn = new int[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            int[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    int[] newArray = new int[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new int[normalizeToLength];
        }
        return rtn;
    }

    public static boolean[][] normalizeArrays(int normalizeToLength, boolean[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        boolean[][] rtn = new boolean[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            boolean[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    boolean[] newArray = new boolean[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new boolean[normalizeToLength];
        }
        return rtn;
    }

    public static short[][] normalizeArrays(int normalizeToLength, short[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        short[][] rtn = new short[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            short[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    short[] newArray = new short[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new short[normalizeToLength];
        }
        return rtn;
    }

    public static String getDurationHMS(double seconds) {
        int day = (int)TimeUnit.SECONDS.toDays((long)seconds);
        long hours = TimeUnit.SECONDS.toHours((long)seconds) - (long)day * 24L;
        long minute = TimeUnit.SECONDS.toMinutes((long)seconds) - TimeUnit.SECONDS.toHours((long)seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds((long)seconds) - TimeUnit.SECONDS.toMinutes((long)seconds) * 60L;
        long ms = Math.round((seconds - (double)((long)seconds)) * 1000.0);
        StringBuilder hms = new StringBuilder();
        if (day > 0) {
            hms.append(day + "d ");
        }
        if (day > 0 || hours > 0L) {
            hms.append(hours + "h ");
        }
        if (day > 0 || hours > 0L || minute > 0L) {
            hms.append(String.format("%2d", minute) + "' ");
        }
        hms.append(String.format("%2d", second));
        if (day == 0 && hours == 0L && minute < 3L) {
            hms.append('.').append(String.format("%03d", ms));
        }
        hms.append('\"');
        return hms.toString();
    }
}

