/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.expr;

import io.github.spannm.jackcess.expr.LocaleContext;
import io.github.spannm.jackcess.expr.Value;
import io.github.spannm.jackcess.impl.ColumnImpl;
import io.github.spannm.jackcess.impl.expr.BaseValue;
import io.github.spannm.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public class DateTimeValue
extends BaseValue {
    private final Value.Type type;
    private final LocalDateTime val;

    public DateTimeValue(Value.Type _type, LocalDateTime _val) {
        if (!_type.isTemporal()) {
            throw new IllegalArgumentException("invalid date/time type");
        }
        this.type = _type;
        this.val = _val;
    }

    @Override
    public Value.Type getType() {
        return this.type;
    }

    @Override
    public Object get() {
        return this.val;
    }

    protected Double getNumber(LocaleContext ctx) {
        return ColumnImpl.toDateDouble(this.val);
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return true;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return ValueSupport.getDateFormatForType(ctx, this.getType()).format(this.val);
    }

    @Override
    public LocalDateTime getAsLocalDateTime(LocaleContext ctx) {
        return this.val;
    }

    @Override
    public Value getAsDateTimeValue(LocaleContext ctx) {
        return this;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this.roundToLongInt(ctx);
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this.getNumber(ctx);
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this.getNumber(ctx));
    }
}

