/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMACCSECReplyDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    DDMACCSECReplyDataStream() {
    }

    boolean checkReply(int byteType) {
        if (this.getCodePoint() != 5292) {
            Trace.log(2, "DDM ACCSEC failed with code point:", this.data_, 8, 2);
            return false;
        }
        if (byteType == 0) {
            if (this.data_.length < 19) {
                Trace.log(2, "DDM ACCSEC failed: system may be set to *KERBEROS while client is not.", this.data_);
                return false;
            }
            int rc = this.get16bit(18);
            if (rc == 4516) {
                Trace.log(2, "DDM ACCSEC SECCHKCD failed:", this.data_, 18, 2);
                return false;
            }
            if (rc != 4572) {
                Trace.log(2, "DDM ACCSEC SECTKN failed:", this.data_, 18, 2);
                return false;
            }
        }
        return true;
    }

    boolean checkReplyForEUSRIDPWD(int byteType) {
        if (this.getCodePoint() != 5292) {
            Trace.log(2, "DDM ACCSEC failed with code point:", this.data_, 8, 2);
            return false;
        }
        if (byteType == 0) {
            if (this.data_.length < 17) {
                Trace.log(2, "DDM ACCSEC failed: system may be set to *KERBEROS while client is not.", this.data_);
                return false;
            }
            int rc = this.get16bit(12);
            if (rc == 4516) {
                Trace.log(2, "DDM ACCSEC SECCHKCD failed:", this.data_, 12, 2);
                return false;
            }
            if (rc != 4514) {
                Trace.log(2, "DDM ACCSEC SECMECH failed:", this.data_, 12, 2);
                return false;
            }
            rc = this.get16bit(14);
            if (rc != 9) {
                Trace.log(2, "DDM ACCSEC EUSRIDPWD failed:", this.data_, 14, 2);
                return false;
            }
        }
        return true;
    }

    byte[] getServerSeed() {
        int type = this.get16bit(14);
        if (type != 9) {
            byte[] seed = new byte[8];
            System.arraycopy(this.data_, 20, seed, 0, 8);
            return seed;
        }
        if (this.data_.length >= 84) {
            byte[] seed = new byte[64];
            System.arraycopy(this.data_, 20, seed, 0, 64);
            return seed;
        }
        byte[] seed = new byte[32];
        System.arraycopy(this.data_, 20, seed, 0, 32);
        return seed;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM ACCSEC reply...");
        }
        if (this.readFromStream(in, header = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM EXCSAT Reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 6);
        this.readAfterHeader(in);
    }

    public boolean aesUpgrade() {
        int encoding;
        int op;
        int type = this.get16bit(14);
        return type == 9 && (op = this.get16bit(18)) == 6409 && (encoding = this.get16bit(20)) == 2;
    }
}

