/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class JacksonAvroParserImpl
extends AvroParserImpl {
    public static final int[] sUtf8UnitLengths;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    public JacksonAvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, InputStream in) {
        super(ctxt, parserFeatures, avroFeatures, codec);
        this._inputStream = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._bufferRecyclable = true;
    }

    public JacksonAvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, byte[] data, int offset, int len) {
        super(ctxt, parserFeatures, avroFeatures, codec);
        this._inputStream = null;
        this._inputBuffer = data;
        this._inputPtr = offset;
        this._inputEnd = offset + len;
    }

    protected void _releaseBuffers() throws IOException {
        byte[] buf;
        super._releaseBuffers();
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    @Override
    public String nextTextValue() throws IOException {
        if (this.nextToken() == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        return null;
    }

    @Override
    public boolean hasTextCharacters() {
        return this._currToken == JsonToken.VALUE_STRING;
    }

    @Override
    public String getText() throws IOException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._avroContext.getCurrentName();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this.getNumberValue().toString();
            }
            return this._currToken.asString();
        }
        return null;
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsToWriter(writer);
        }
        if (t == JsonToken.FIELD_NAME) {
            String n = this._avroContext.getCurrentName();
            writer.write(n);
            return n.length();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] ch = t.asCharArray();
            writer.write(ch);
            return ch.length;
        }
        return 0;
    }

    @Override
    public JsonToken decodeIntToken() throws IOException {
        this._numberInt = this.decodeInt();
        this._numTypesValid = 1;
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public final int decodeInt() throws IOException {
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 5) {
            return this._decodeIntSlow();
        }
        byte[] buf = this._inputBuffer;
        byte b = buf[ptr++];
        int i = b & 0x7F;
        if (b < 0) {
            b = buf[ptr++];
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = buf[ptr++];
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = buf[ptr++];
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        if ((b = buf[ptr++]) < 0) {
                            this._inputPtr = ptr;
                            this._reportInvalidNegative(b);
                        }
                        i += b << 28;
                    }
                }
            }
        }
        this._inputPtr = ptr;
        return i >>> 1 ^ -(i & 1);
    }

    public int _decodeIntSlow() throws IOException {
        byte b = this._nextByteGuaranteed();
        int i = b & 0x7F;
        if (b < 0) {
            b = this._nextByteGuaranteed();
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = this._nextByteGuaranteed();
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = this._nextByteGuaranteed();
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        b = this._nextByteGuaranteed();
                        if (b < 0) {
                            this._reportInvalidNegative(b);
                        }
                        i += b << 28;
                    }
                }
            }
        }
        return i >>> 1 ^ -(i & 1);
    }

    @Override
    public void skipInt() throws IOException {
        byte b;
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 5) {
            this._skipIntSlow();
            return;
        }
        byte[] buf = this._inputBuffer;
        if (buf[ptr++] < 0 && buf[ptr++] < 0 && buf[ptr++] < 0 && buf[ptr++] < 0 && (b = buf[ptr++]) < 0) {
            this._inputPtr = ptr;
            this._reportInvalidNegative(b);
        }
        this._inputPtr = ptr;
    }

    public void _skipIntSlow() throws IOException {
        byte b;
        if (this._nextByteGuaranteed() < 0 && this._nextByteGuaranteed() < 0 && this._nextByteGuaranteed() < 0 && this._nextByteGuaranteed() < 0 && (b = this._nextByteGuaranteed()) < 0) {
            this._reportInvalidNegative(b);
        }
    }

    @Override
    public JsonToken decodeLongToken() throws IOException {
        this._numberLong = this.decodeLong();
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public long decodeLong() throws IOException {
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 10) {
            return this._decodeLongSlow();
        }
        byte[] buf = this._inputBuffer;
        byte b = buf[ptr++];
        int i = b & 0x7F;
        if (b < 0) {
            b = buf[ptr++];
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = buf[ptr++];
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = buf[ptr++];
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        return this._decodeLong2(ptr, i);
                    }
                }
            }
        }
        this._inputPtr = ptr;
        i = i >>> 1 ^ -(i & 1);
        return i;
    }

    private long _decodeLong2(int ptr, long lo) throws IOException {
        byte[] buf = this._inputBuffer;
        byte b = buf[ptr++];
        int i = b & 0x7F;
        if (b < 0) {
            b = buf[ptr++];
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = buf[ptr++];
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = buf[ptr++];
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        b = buf[ptr++];
                        int inner = b & 0x7F;
                        if (b < 0) {
                            if ((b = buf[ptr++]) < 0) {
                                this._inputPtr = ptr;
                                this._reportInvalidNegative(b);
                            }
                            inner |= (b & 1) << 7;
                        }
                        lo |= (long)inner << 56;
                    }
                }
            }
        }
        this._inputPtr = ptr;
        return (lo |= (long)i << 28) >>> 1 ^ -(lo & 1L);
    }

    public long _decodeLongSlow() throws IOException {
        byte b = this._nextByteGuaranteed();
        int i = b & 0x7F;
        if (b < 0) {
            b = this._nextByteGuaranteed();
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = this._nextByteGuaranteed();
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = this._nextByteGuaranteed();
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        return this._decodeLongSlow2(i);
                    }
                }
            }
        }
        i = i >>> 1 ^ -(i & 1);
        return i;
    }

    private long _decodeLongSlow2(long lo) throws IOException {
        byte b = this._nextByteGuaranteed();
        int i = b & 0x7F;
        if (b < 0) {
            i &= 0x7F;
            b = this._nextByteGuaranteed();
            i += (b & 0x7F) << 7;
            if (b < 0) {
                b = this._nextByteGuaranteed();
                i += (b & 0x7F) << 14;
                if (b < 0) {
                    b = this._nextByteGuaranteed();
                    i += (b & 0x7F) << 21;
                    if (b < 0) {
                        lo |= (long)i << 28;
                        b = this._nextByteGuaranteed();
                        i = b & 0x7F;
                        if (b < 0) {
                            b = this._nextByteGuaranteed();
                            if (b < 0) {
                                this._reportInvalidNegative(b);
                            }
                            i |= b << 7;
                        }
                        return (lo |= (long)i << 56) >>> 1 ^ -(lo & 1L);
                    }
                }
            }
        }
        return (lo |= (long)i << 28) >>> 1 ^ -(lo & 1L);
    }

    @Override
    public void skipLong() throws IOException {
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 10) {
            this._skipLongSlow();
            return;
        }
        byte[] buf = this._inputBuffer;
        if (buf[ptr++] < 0) {
            byte b;
            int maxLeft = 9;
            do {
                b = this._nextByteGuaranteed();
            } while (--maxLeft > 0 && b < 0);
            if (b < 0) {
                this._reportInvalidNegative(b);
            }
        }
        this._inputPtr = ptr;
    }

    public void _skipLongSlow() throws IOException {
        if (this._nextByteGuaranteed() < 0) {
            byte b;
            int maxLeft = 9;
            do {
                b = this._nextByteGuaranteed();
            } while (--maxLeft > 0 && b < 0);
            if (b < 0) {
                this._reportInvalidNegative(b);
            }
        }
    }

    @Override
    public JsonToken decodeFloat() throws IOException {
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 4) {
            this._loadToHaveAtLeast(4);
            ptr = this._inputPtr;
        }
        byte[] buf = this._inputBuffer;
        this._inputPtr = ptr + 4;
        int i = buf[ptr] & 0xFF | (buf[ptr + 1] & 0xFF) << 8 | (buf[ptr + 2] & 0xFF) << 16 | buf[ptr + 3] << 24;
        this._numberFloat = Float.intBitsToFloat(i);
        this._numTypesValid = 32;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public void skipFloat() throws IOException {
        this._skip(4);
    }

    @Override
    public JsonToken decodeDouble() throws IOException {
        int ptr = this._inputPtr;
        if (this._inputEnd - ptr < 8) {
            this._loadToHaveAtLeast(8);
            ptr = this._inputPtr;
        }
        byte[] buf = this._inputBuffer;
        int i = buf[ptr] & 0xFF | (buf[ptr + 1] & 0xFF) << 8 | (buf[ptr + 2] & 0xFF) << 16 | buf[ptr + 3] << 24;
        int i2 = buf[ptr += 4] & 0xFF | (buf[ptr + 1] & 0xFF) << 8 | (buf[ptr + 2] & 0xFF) << 16 | buf[ptr + 3] << 24;
        this._inputPtr = ptr + 4;
        this._numberDouble = Double.longBitsToDouble((long)i & 0xFFFFFFFFL | (long)i2 << 32);
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public void skipDouble() throws IOException {
        this._skip(8);
    }

    @Override
    public JsonToken decodeStringToken() throws IOException {
        this.decodeString();
        return JsonToken.VALUE_STRING;
    }

    @Override
    public void decodeString() throws IOException {
        int len = this.decodeInt();
        if (len <= 0) {
            if (len < 0) {
                this._reportError("Invalid length indicator for String: " + len);
            }
            this._textBuffer.resetWithEmpty();
            return;
        }
        if (len > this._inputEnd - this._inputPtr) {
            if (len >= this._inputBuffer.length) {
                this._finishLongText(len);
                return;
            }
            this._loadToHaveAtLeast(len);
        }
        this._finishShortText(len);
    }

    @Override
    public void skipString() throws IOException {
        int len = this.decodeInt();
        if (len <= 0) {
            if (len < 0) {
                this._reportError("Invalid length indicator for String: " + len);
            }
            return;
        }
        this._skip(len);
    }

    private final String _finishShortText(int len) throws IOException {
        int i;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        if (outBuf.length < len) {
            outBuf = this._textBuffer.expandCurrentSegment(len);
        }
        int outPtr = 0;
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + len;
        while ((i = inputBuf[inPtr]) >= 0) {
            outBuf[outPtr++] = (char)i;
            if (++inPtr != end) continue;
            return this._textBuffer.setCurrentAndReturn(outPtr);
        }
        int[] codes = sUtf8UnitLengths;
        do {
            i = inputBuf[inPtr++] & 0xFF;
            switch (codes[i]) {
                case 0: {
                    break;
                }
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    this._reportError("Invalid byte " + Integer.toHexString(i) + " in Unicode text block");
                }
            }
            outBuf[outPtr++] = (char)i;
        } while (inPtr < end);
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _finishLongText(int len) throws IOException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int[] codes = sUtf8UnitLengths;
        int outEnd = outBuf.length;
        while (--len >= 0) {
            int c = this._nextByteGuaranteed() & 0xFF;
            int code = codes[c];
            if (code == 0 && outPtr < outEnd) {
                outBuf[outPtr++] = (char)c;
                continue;
            }
            if ((len -= code) < 0) {
                throw this._constructError("Malformed UTF-8 character at end of long (non-chunked) text segment");
            }
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    byte d = this._nextByteGuaranteed();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF, this._inputPtr);
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                    break;
                }
                case 2: {
                    c = this._decodeUTF8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUTF8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                        outEnd = outBuf.length;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outEnd) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
                outEnd = outBuf.length;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final int _decodeUTF8_3(int c1) throws IOException {
        c1 &= 0xF;
        byte d = this._nextByteGuaranteed();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        d = this._nextByteGuaranteed();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUTF8_4(int c) throws IOException {
        byte d = this._nextByteGuaranteed();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        d = this._nextByteGuaranteed();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        d = this._nextByteGuaranteed();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    private void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    private void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    private void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    @Override
    public JsonToken decodeBytes() throws IOException {
        int len = this.decodeInt();
        if (len <= 0) {
            if (len < 0) {
                this._reportError("Invalid length indicator for Bytes: " + len);
            }
            this._binaryValue = NO_BYTES;
        } else {
            byte[] b = new byte[len];
            this._read(b, 0, len);
            this._binaryValue = b;
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public void skipBytes() throws IOException {
        int len = this.decodeInt();
        if (len <= 0) {
            if (len < 0) {
                this._reportError("Invalid length indicator for Bytes: " + len);
            }
            this._binaryValue = NO_BYTES;
        } else {
            this._skip(len);
        }
    }

    @Override
    public JsonToken decodeFixed(int size) throws IOException {
        byte[] data = new byte[size];
        this._read(data, 0, size);
        this._binaryValue = data;
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public void skipFixed(int size) throws IOException {
        this._skip(size);
    }

    private final void _read(byte[] target, int offset, int len) throws IOException {
        int count;
        int ptr = this._inputPtr;
        int available = this._inputEnd - ptr;
        if (len <= available) {
            System.arraycopy(this._inputBuffer, ptr, target, offset, len);
            this._inputPtr = ptr + len;
            return;
        }
        System.arraycopy(this._inputBuffer, ptr, target, offset, available);
        this._inputPtr = ptr + available;
        offset += available;
        int left = len - available;
        do {
            if ((count = this._inputStream.read(target, offset, left)) <= 0) {
                this._reportError("Needed to read " + len + " bytes, reached end-of-input after reading " + (len - left));
            }
            offset += count;
        } while ((left -= count) > 0);
    }

    private final void _skip(int len) throws IOException {
        int ptr = this._inputPtr;
        int available = this._inputEnd - ptr;
        int left = len - available;
        if (left <= 0) {
            this._inputPtr = ptr + len;
            return;
        }
        this._inputPtr = this._inputEnd;
        if (this._inputStream != null) {
            int skipped;
            while ((skipped = (int)this._inputStream.skip(left)) >= 0 && (left -= skipped) > 0) {
            }
        }
        if (left > 0) {
            this._reportError("Only able to skip " + (len - left) + " bytes before end-of-input (needed " + len + ")");
        }
    }

    private final void _skipL(long len) throws IOException {
        int ptr = this._inputPtr;
        int available = this._inputEnd - ptr;
        long left = len - (long)available;
        if (left <= 0L) {
            this._inputPtr = ptr + (int)len;
            return;
        }
        this._inputPtr = this._inputEnd;
        if (this._inputStream != null) {
            int skipped;
            while ((skipped = (int)this._inputStream.skip(left)) >= 0 && (left -= (long)skipped) > 0L) {
            }
        }
        if (left > 0L) {
            this._reportError("Only able to skip " + (len - left) + " bytes before end-of-input (needed " + len + ")");
        }
    }

    @Override
    public long decodeArrayStart() throws IOException {
        return this._decodeChunkLength();
    }

    @Override
    public long decodeArrayNext() throws IOException {
        return this._decodeChunkLength();
    }

    @Override
    public long skipArray() throws IOException {
        return this._skipChunkElements();
    }

    private final long _decodeChunkLength() throws IOException {
        long result = this.decodeLong();
        if (result < 0L) {
            this.skipLong();
            result = -result;
        }
        return result;
    }

    private long _skipChunkElements() throws IOException {
        int result = this.decodeInt();
        while (result < 0) {
            long bytecount = this.decodeLong();
            this._skipL(bytecount);
            result = this.decodeInt();
        }
        return result;
    }

    @Override
    public String decodeMapKey() throws IOException {
        this.decodeString();
        return this._textBuffer.contentsAsString();
    }

    @Override
    public long decodeMapStart() throws IOException {
        return this._decodeChunkLength();
    }

    @Override
    public long decodeMapNext() throws IOException {
        return this._decodeChunkLength();
    }

    @Override
    public long skipMap() throws IOException {
        return this._skipChunkElements();
    }

    @Override
    public JsonToken decodeBoolean() throws IOException {
        byte b = this._nextByteGuaranteed();
        return b == 1 ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override
    public void skipBoolean() throws IOException {
        this._skipByteGuaranteed();
    }

    @Override
    public int decodeIndex() throws IOException {
        this._branchIndex = this.decodeInt();
        return this._branchIndex;
    }

    @Override
    public int decodeEnum() throws IOException {
        this._enumIndex = this.decodeInt();
        return this._enumIndex;
    }

    @Override
    public boolean checkInputEnd() throws IOException {
        if (this._closed) {
            return true;
        }
        if (this._inputPtr < this._inputEnd) {
            return false;
        }
        return !this._loadMore();
    }

    @Override
    protected JsonToken setString(String str) throws IOException {
        this._textBuffer.resetWithString(str);
        return JsonToken.VALUE_STRING;
    }

    private final byte _nextByteGuaranteed() throws IOException {
        int ptr = this._inputPtr;
        if (ptr < this._inputEnd) {
            byte b = this._inputBuffer[ptr];
            this._inputPtr = ptr + 1;
            return b;
        }
        return this._nextByteGuaranteed2();
    }

    private final byte _nextByteGuaranteed2() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    private final void _skipByteGuaranteed() throws IOException {
        int ptr;
        if ((ptr = this._inputPtr++) < this._inputEnd) {
            this._inputPtr = ptr + 1;
            return;
        }
        this._loadMoreGuaranteed();
    }

    protected final boolean _loadMore() throws IOException {
        if (this._inputStream != null) {
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            this._currInputProcessed += (long)this._inputEnd;
            this._inputPtr = 0;
            if (count > 0) {
                this._inputEnd = count;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws IOException {
        int amount = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        if (this._inputPtr > 0) {
            if (amount > 0) {
                System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, amount);
                this._inputEnd = amount;
            } else {
                this._inputEnd = 0;
            }
        }
        this._inputPtr = 0;
        if (this._inputStream == null) {
            this._reportError("Needed to read %d bytes, reached end-of-input", minAvailable);
            return;
        }
        while (this._inputEnd < minAvailable) {
            int count = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + amount + " bytes");
                }
                this._reportError("Needed to read %d bytes, missed %d before end-of-input", minAvailable, minAvailable);
            }
            this._inputEnd += count;
        }
    }

    private void _reportInvalidNegative(int v) throws IOException {
        this._reportError("Invalid negative byte %x at end of VInt", v);
    }

    static {
        int[] table = new int[256];
        for (int c = 128; c < 256; ++c) {
            int code = (c & 0xE0) == 192 ? 1 : ((c & 0xF0) == 224 ? 2 : ((c & 0xF8) == 240 ? 3 : -1));
            table[c] = code;
        }
        sUtf8UnitLengths = table;
    }
}

