/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import net.openhft.chronicle.core.Maths;

public class ClassMetrics {
    private final int offset;
    private final int length;

    public ClassMetrics(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    @Deprecated
    public static void updateJar(String jarToUpdate, String sourceFile, String fileNameInJar) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + new File(jarToUpdate).toURI());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Path externalFile = new File(sourceFile).toPath();
            Path pathInZipfile = zipfs.getPath(fileNameInJar, new String[0]);
            Files.copy(externalFile, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassMetrics that = (ClassMetrics)o;
        return this.offset == that.offset && this.length == that.length;
    }

    public int hashCode() {
        return Maths.hash(this.offset, this.length);
    }

    public String toString() {
        return "ClassMetrics{offset=" + this.offset + ", length=" + this.length + '}';
    }
}

