/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;

@Experimental
public class TraceOptions {
    private static final String NAMED_REPORTER_CONFIG_PREFIX = "traces.reporter.<name>";
    public static final ConfigOption<String> TRACE_REPORTERS_LIST = ConfigOptions.key("traces.reporters").stringType().noDefaultValue().withDescription("An optional list of trace reporter names. If configured, only reporters whose name matches any of the names in the list will be started. Otherwise, all reporters that could be found in the configuration will be started.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=1)
    public static final ConfigOption<String> REPORTER_FACTORY_CLASS = ConfigOptions.key("factory.class").stringType().noDefaultValue().withDescription("The reporter factory class to use for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=6)
    public static final ConfigOption<String> REPORTER_CONFIG_PARAMETER = ConfigOptions.key("<parameter>").stringType().noDefaultValue().withDescription("Configures the parameter <parameter> for the reporter named <name>.");
    @Documentation.SuffixOption(value="traces.reporter.<name>")
    @Documentation.Section(value={"trace_reporters"}, position=3)
    public static final ConfigOption<Map<String, String>> REPORTER_ADDITIONAL_VARIABLES = ConfigOptions.key("scope.variables.additional").mapType().defaultValue(Collections.emptyMap()).withDescription("The map of additional variables that should be included for the reporter named <name>.");

    @Experimental
    public static Configuration forTraceReporter(Configuration configuration, String reporterName) {
        return new DelegatingConfiguration(configuration, "traces.reporter." + reporterName + ".");
    }

    private TraceOptions() {
    }
}

