/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.messages.ResponseDate;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="Part", strict=false)
public class Part {
    @Element(name="PartNumber", required=false)
    private int partNumber;
    @Element(name="ETag", required=false)
    private String etag;
    @Element(name="LastModified", required=false)
    private ResponseDate lastModified;
    @Element(name="Size", required=false)
    private Long size;
    @Element(name="ChecksumCRC32", required=false)
    private String checksumCRC32;
    @Element(name="ChecksumCRC32C", required=false)
    private String checksumCRC32C;
    @Element(name="ChecksumCRC64NVME", required=false)
    private String checksumCRC64NVME;
    @Element(name="ChecksumSHA1", required=false)
    private String checksumSHA1;
    @Element(name="ChecksumSHA256", required=false)
    private String checksumSHA256;

    public Part() {
    }

    public Part(int partNumber, String etag) {
        this.partNumber = partNumber;
        this.etag = etag;
    }

    public Part(int partNumber, String etag, String checksumCRC32, String checksumCRC32C, String checksumCRC64NVME, String checksumSHA1, String checksumSHA256) {
        this.partNumber = partNumber;
        this.etag = etag;
        this.checksumCRC32 = checksumCRC32;
        this.checksumCRC32C = checksumCRC32C;
        this.checksumCRC64NVME = checksumCRC64NVME;
        this.checksumSHA1 = checksumSHA1;
        this.checksumSHA256 = checksumSHA256;
    }

    public int partNumber() {
        return this.partNumber;
    }

    public String etag() {
        return this.etag.replaceAll("\"", "");
    }

    public ZonedDateTime lastModified() {
        return this.lastModified.zonedDateTime();
    }

    public long partSize() {
        return this.size;
    }

    public String checksumCRC32() {
        return this.checksumCRC32;
    }

    public String checksumCRC32C() {
        return this.checksumCRC32C;
    }

    public String checksumCRC64NVME() {
        return this.checksumCRC64NVME;
    }

    public String checksumSHA1() {
        return this.checksumSHA1;
    }

    public String checksumSHA256() {
        return this.checksumSHA256;
    }
}

