/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.auth;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.auth.AuthUtils;
import com.datastax.oss.driver.api.core.auth.PlainTextAuthProviderBase;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PlainTextAuthProvider
extends PlainTextAuthProviderBase {
    private final DriverExecutionProfile config;

    public PlainTextAuthProvider(DriverContext context) {
        super(context.getSessionName());
        this.config = context.getConfig().getDefaultProfile();
    }

    @Override
    @NonNull
    protected PlainTextAuthProviderBase.Credentials getCredentials(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
        AuthUtils.validateConfigPresent(this.config, PlainTextAuthProvider.class.getName(), endPoint, DefaultDriverOption.AUTH_PROVIDER_USER_NAME, DefaultDriverOption.AUTH_PROVIDER_PASSWORD);
        String authorizationId = this.config.getString(DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID, "");
        assert (authorizationId != null);
        return new PlainTextAuthProviderBase.Credentials(this.config.getString(DefaultDriverOption.AUTH_PROVIDER_USER_NAME).toCharArray(), this.config.getString(DefaultDriverOption.AUTH_PROVIDER_PASSWORD).toCharArray(), authorizationId.toCharArray());
    }
}

