/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.PackageMessages;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

public abstract class BodyHttpServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = 6576714217004890327L;
    private final PackageMessages messages = new PackageMessages(this.getClass());

    protected boolean useXML(HttpServletRequest request) {
        return "Y".equalsIgnoreCase(request.getParameter("xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(this.getContextPath())) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.messages.getString("Log.Execute", new String[0]));
        }
        boolean useXML = this.useXML(request);
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        try {
            if (useXML) {
                this.startXml(response, out);
            } else {
                this.beginHtml(response, out);
            }
            WebResult result = this.generateBody(request, response, useXML, this.variables);
            if (result != null) {
                out.println(result.getXml());
            }
        }
        catch (Exception e) {
            String st = ExceptionUtils.getFullStackTrace((Throwable)e);
            if (useXML) {
                out.println(new WebResult("ERROR", st).getXml());
            } else {
                out.println("<p><pre>");
                out.println(Encode.forHtml((String)st));
                out.println("</pre>");
            }
        }
        finally {
            if (!useXML) {
                this.endHtml(out);
            }
            out.flush();
            IOUtils.closeQuietly((Writer)out);
        }
    }

    protected void beginHtml(HttpServletResponse response, PrintWriter out) {
        response.setContentType("text/html;charset=UTF-8");
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<TITLE>");
        out.println(Encode.forHtml((String)this.getTitle()));
        out.println("</TITLE>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
        out.println("</HEAD>");
        out.println("<BODY>");
    }

    protected void endHtml(PrintWriter out) {
        out.println("<p>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    protected void startXml(HttpServletResponse response, PrintWriter out) {
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
    }

    abstract WebResult generateBody(HttpServletRequest var1, HttpServletResponse var2, boolean var3, IVariables var4) throws Exception;

    @Override
    public String getService() {
        return this.getContextPath() + " (" + this.getTitle() + ")";
    }

    private String getTitle() {
        return this.messages.getString("Title", new String[0]);
    }
}

