/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.deployment.version;

import java.util.Objects;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.deployment.version.VersionParseException;

class UnitVersion
implements Version {
    private final short major;
    private final short minor;
    private final short patch;

    UnitVersion(short major, short minor, short patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public String render() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static UnitVersion parse(String rawVersion) {
        Objects.requireNonNull(rawVersion);
        try {
            String[] split = rawVersion.split("\\.", -1);
            if (split.length > 3 || split.length == 0) {
                throw new VersionParseException(rawVersion, "Invalid version format");
            }
            short major = Short.parseShort(split[0]);
            short minor = split.length > 1 ? Short.parseShort(split[1]) : (short)0;
            short patch = split.length > 2 ? Short.parseShort(split[2]) : (short)0;
            return new UnitVersion(major, minor, patch);
        }
        catch (NumberFormatException e) {
            throw new VersionParseException(rawVersion, e);
        }
    }

    @Override
    public int compareTo(Version o) {
        if (o == LATEST) {
            return -1;
        }
        UnitVersion version = (UnitVersion)o;
        int majorCompare = Short.compare(this.major, version.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Short.compare(this.minor, version.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        return Short.compare(this.patch, version.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitVersion version = (UnitVersion)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.patch == version.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return this.render();
    }
}

