/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl;

import org.apache.ignite3.internal.raft.server.impl.RaftServiceEventInterceptor;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.RpcContext;
import org.apache.ignite3.raft.jraft.rpc.RpcProcessor;

public class NotifyElectProcessor
implements RpcProcessor<CliRequests.SubscriptionLeaderChangeRequest> {
    private final RaftServiceEventInterceptor serviceEventInterceptor;
    private final RaftMessagesFactory msgFactory;

    public NotifyElectProcessor(RaftMessagesFactory msgFactory, RaftServiceEventInterceptor serviceEventInterceptor) {
        this.msgFactory = msgFactory;
        this.serviceEventInterceptor = serviceEventInterceptor;
    }

    @Override
    public void handleRequest(RpcContext rpcCtx, CliRequests.SubscriptionLeaderChangeRequest request) {
        if (request.subscribe()) {
            this.serviceEventInterceptor.subscribe(request.groupId(), rpcCtx.getSender(), term -> rpcCtx.sendResponseAsync(this.msgFactory.leaderChangeNotification().groupId(request.groupId()).term((long)term).build()));
        } else {
            this.serviceEventInterceptor.unsubscribe(request.groupId(), rpcCtx.getSender());
        }
        rpcCtx.sendResponse(this.msgFactory.subscriptionLeaderChangeRequestAcknowledge().build());
    }

    @Override
    public String interest() {
        return CliRequests.SubscriptionLeaderChangeRequest.class.getName();
    }
}

