/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class QuerySchemaPatch {
    private String conflictsMessage;
    private Collection<SchemaAbstractOperation> patchOperations;
    private Collection<QueryEntity> entityToAdd;

    public QuerySchemaPatch(@NotNull Collection<SchemaAbstractOperation> patchOperations, @NotNull Collection<QueryEntity> entityToAdd, String conflictsMessage) {
        this.patchOperations = patchOperations;
        this.entityToAdd = entityToAdd;
        this.conflictsMessage = conflictsMessage;
    }

    public boolean hasConflicts() {
        return this.conflictsMessage != null && !this.conflictsMessage.isEmpty();
    }

    public String getConflictsMessage() {
        return this.conflictsMessage;
    }

    public boolean isEmpty() {
        return this.patchOperations.isEmpty() && this.entityToAdd.isEmpty();
    }

    @NotNull
    public Collection<SchemaAbstractOperation> getPatchOperations() {
        return this.patchOperations;
    }

    @NotNull
    public Collection<QueryEntity> getEntityToAdd() {
        return this.entityToAdd;
    }

    public String toString() {
        return S.toString(QuerySchemaPatch.class, this);
    }
}

