/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.BiFunctionWithException;

@Internal
public final class LinkedOptionalMapSerializer {
    private static final long HEADER = 5440760593776L;

    private LinkedOptionalMapSerializer() {
    }

    public static <K, V> void writeOptionalMap(DataOutputView out, LinkedOptionalMap<K, V> map, BiConsumerWithException<DataOutputView, K, IOException> keyWriter, BiConsumerWithException<DataOutputView, V, IOException> valueWriter) throws IOException {
        out.writeLong(5440760593776L);
        out.writeInt(map.size());
        map.forEach((keyName, key, value) -> {
            out.writeUTF(keyName);
            if (key == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                LinkedOptionalMapSerializer.writeFramed(out, keyWriter, key);
            }
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                LinkedOptionalMapSerializer.writeFramed(out, valueWriter, value);
            }
        });
    }

    public static <K, V> LinkedOptionalMap<K, V> readOptionalMap(DataInputView in, BiFunctionWithException<DataInputView, String, K, IOException> keyReader, BiFunctionWithException<DataInputView, String, V, IOException> valueReader) throws IOException {
        long header = in.readLong();
        Preconditions.checkState(header == 5440760593776L, "Corrupted stream received header %s", header);
        long mapSize = in.readInt();
        LinkedOptionalMap<Object, Object> map = new LinkedOptionalMap<Object, Object>();
        int i = 0;
        while ((long)i < mapSize) {
            String keyName = in.readUTF();
            Object key = in.readBoolean() ? (Object)LinkedOptionalMapSerializer.tryReadFrame(in, keyName, keyReader) : null;
            Object value = in.readBoolean() ? (Object)LinkedOptionalMapSerializer.tryReadFrame(in, keyName, valueReader) : null;
            map.put(keyName, key, value);
            ++i;
        }
        return map;
    }

    private static <T> void writeFramed(DataOutputView out, BiConsumerWithException<DataOutputView, T, IOException> writer, T item) throws IOException {
        DataOutputSerializer frame = new DataOutputSerializer(64);
        writer.accept((Object)frame, item);
        byte[] buffer = frame.getSharedBuffer();
        int bufferSize = frame.length();
        out.writeInt(bufferSize);
        out.write(buffer, 0, bufferSize);
    }

    @Nullable
    private static <T> T tryReadFrame(DataInputView in, String keyName, BiFunctionWithException<DataInputView, String, T, IOException> reader) throws IOException {
        int bufferSize = in.readInt();
        byte[] buffer = new byte[bufferSize];
        in.readFully(buffer);
        DataInputDeserializer frame = new DataInputDeserializer(buffer);
        return (T)reader.apply((Object)frame, (Object)keyName);
    }
}

