/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.common.IOUtils;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.admin.CommandOutputter;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.admin.CommandResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamOutputter
implements CommandOutputter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamOutputter.class);
    private final String clientIP;

    public StreamOutputter(String clientIP) {
        this.clientIP = clientIP;
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public void output(CommandResponse response, OutputStream os) {
        try (InputStream is = response.getInputStream();){
            IOUtils.copyBytes(is, os, 1024, true);
        }
        catch (IOException e) {
            LOG.warn("Exception streaming out data to {}", (Object)this.clientIP, (Object)e);
        }
    }
}

