/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.command;

import java.io.PrintWriter;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ServerCnxn;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.ServerMetrics;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.server.command.AbstractFourLetterCommand;

public class MonitorCommand
extends AbstractFourLetterCommand {
    MonitorCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        super(pw, serverCnxn);
    }

    @Override
    public void commandRun() {
        if (!this.isZKServerRunning()) {
            this.pw.println("This ZooKeeper instance is not currently serving requests");
            return;
        }
        this.zkServer.dumpMonitorValues(this::print);
        ServerMetrics.getMetrics().getMetricsProvider().dump(this::print);
    }

    private void print(String key, Object value) {
        if (value == null) {
            this.output(key, null);
        } else if (value instanceof Long || value instanceof Integer) {
            this.output(key, value + "");
        } else if (value instanceof Number) {
            this.output(key, ((Number)value).doubleValue() + "");
        } else {
            this.output(key, value.toString());
        }
    }

    private void output(String key, String value) {
        this.pw.print("zk_");
        this.pw.print(key);
        this.pw.print("\t");
        this.pw.println(value);
    }
}

