/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.iceberg.io.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableIteratorWrapper<T>
implements CloseableIterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableIteratorWrapper.class);
    private final Closeable[] closeables;
    private final CloseableIterator<T> closeableIterator;

    public CloseableIteratorWrapper(CloseableIterator<T> closeableIterator, Closeable ... closeables) {
        this.closeableIterator = closeableIterator;
        this.closeables = closeables;
    }

    public void close() throws IOException {
        boolean closeFailure = false;
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Throwable t) {
                    closeFailure = true;
                    LOG.error("Exception suppressed when attempting to close resources", t);
                }
            }
        }
        this.closeableIterator.close();
        if (closeFailure) {
            throw new IOException("Some error encounter when close these Closeable. Please see details in error log");
        }
    }

    public boolean hasNext() {
        return this.closeableIterator.hasNext();
    }

    public T next() {
        return (T)this.closeableIterator.next();
    }
}

