/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.amoro.utils.map.RocksDBBackend;
import org.apache.amoro.utils.map.SimpleMap;
import org.apache.amoro.utils.map.SizeEstimator;

public class SimpleSpillableMap<K, T>
implements SimpleMap<K, T> {
    private static final int RECORDS_TO_SKIP_FOR_ESTIMATING = 200;
    private final long maxInMemorySizeInBytes;
    private final String backendBaseDir;
    private final SizeEstimator<K> keySizeEstimator;
    private final SizeEstimator<T> valueSizeEstimator;
    private Map<K, T> memoryMap;
    private Optional<SimpleSpilledMap<K, T>> diskBasedMap = Optional.empty();
    private long currentInMemoryMapSize;
    private long estimatedPayloadSize = 0L;
    private int putCount = 0;
    private final SerializationUtil.SimpleSerializer<K> keySerializer;
    private final SerializationUtil.SimpleSerializer<T> valueSerializer;

    protected SimpleSpillableMap(Long maxInMemorySizeInBytes, @Nullable String backendBaseDir, SizeEstimator<K> keySizeEstimator, SizeEstimator<T> valueSizeEstimator) {
        this(maxInMemorySizeInBytes, backendBaseDir, (SerializationUtil.SimpleSerializer<K>)SerializationUtil.JavaSerializer.INSTANT, (SerializationUtil.SimpleSerializer<T>)SerializationUtil.JavaSerializer.INSTANT, keySizeEstimator, valueSizeEstimator);
    }

    protected SimpleSpillableMap(Long maxInMemorySizeInBytes, @Nullable String backendBaseDir, SerializationUtil.SimpleSerializer<K> keySerializer, SerializationUtil.SimpleSerializer<T> valueSerializer, SizeEstimator<K> keySizeEstimator, SizeEstimator<T> valueSizeEstimator) {
        this.memoryMap = Maps.newHashMap();
        this.maxInMemorySizeInBytes = maxInMemorySizeInBytes;
        this.backendBaseDir = backendBaseDir;
        this.currentInMemoryMapSize = 0L;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keySizeEstimator = keySizeEstimator;
        this.valueSizeEstimator = valueSizeEstimator;
    }

    public long getSizeOfFileOnDiskInBytes() {
        return this.diskBasedMap.map(SimpleSpilledMap::sizeOfFileOnDiskInBytes).orElse(0L);
    }

    public int getMemoryMapSize() {
        return this.memoryMap.size();
    }

    public long getMemoryMapSpaceSize() {
        return this.currentInMemoryMapSize;
    }

    public boolean containsKey(K key) {
        return this.memoryMap.containsKey(key) || this.diskBasedMap.map(diskMap -> diskMap.containsKey(key)).orElse(false) != false;
    }

    @Override
    public T get(K key) {
        return Optional.ofNullable(this.memoryMap.get(key)).orElse(this.diskBasedMap.map(diskMap -> diskMap.get(key)).orElse(null));
    }

    @Override
    public void put(K key, T value) {
        if (this.estimatedPayloadSize == 0L) {
            this.estimatedPayloadSize = this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value);
        } else if (++this.putCount % 200 == 0) {
            this.estimatedPayloadSize = (long)((double)this.estimatedPayloadSize * 0.9 + (double)(this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value)) * 0.1);
            this.currentInMemoryMapSize = (long)this.memoryMap.size() * this.estimatedPayloadSize;
        }
        if (this.memoryMap.containsKey(key)) {
            this.memoryMap.put(key, value);
            return;
        }
        if (this.currentInMemoryMapSize < this.maxInMemorySizeInBytes) {
            if (this.memoryMap.put(key, value) == null) {
                this.currentInMemoryMapSize += this.estimatedPayloadSize;
            }
        } else {
            if (!this.diskBasedMap.isPresent()) {
                this.diskBasedMap = Optional.of(new SimpleSpilledMap<K, T>(this.keySerializer, this.valueSerializer, this.backendBaseDir));
            }
            this.diskBasedMap.get().put(key, value);
        }
    }

    @Override
    public void delete(K key) {
        if (this.memoryMap.containsKey(key)) {
            this.currentInMemoryMapSize -= this.estimatedPayloadSize;
            this.memoryMap.remove(key);
        }
        this.diskBasedMap.ifPresent(map -> map.delete(key));
    }

    @Override
    public void close() {
        this.memoryMap = null;
        this.diskBasedMap.ifPresent(SimpleSpilledMap::close);
        this.currentInMemoryMapSize = 0L;
    }

    protected class SimpleSpilledMap<K, T>
    implements SimpleMap<K, T> {
        private final RocksDBBackend rocksDB;
        private final String columnFamily = UUID.randomUUID().toString();
        private final SerializationUtil.SimpleSerializer<K> keySerializer;
        private final SerializationUtil.SimpleSerializer<T> valueSerializer;

        public SimpleSpilledMap(SerializationUtil.SimpleSerializer<K> keySerializer, @Nullable SerializationUtil.SimpleSerializer<T> valueSerializer, String backendBaseDir) {
            this.rocksDB = RocksDBBackend.getOrCreateInstance(backendBaseDir);
            this.rocksDB.addColumnFamily(this.columnFamily);
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public boolean containsKey(K key) {
            return this.rocksDB.get(this.columnFamily, this.keySerializer.serialize(key)) != null;
        }

        @Override
        public T get(K key) {
            return (T)this.valueSerializer.deserialize(this.rocksDB.get(this.columnFamily, this.keySerializer.serialize(key)));
        }

        @Override
        public void put(K key, T value) {
            this.rocksDB.put(this.columnFamily, this.keySerializer.serialize(key), this.valueSerializer.serialize(value));
        }

        @Override
        public void delete(K key) {
            this.rocksDB.delete(this.columnFamily, this.keySerializer.serialize(key));
        }

        @Override
        public void close() {
            this.rocksDB.dropColumnFamily(this.columnFamily);
        }

        public long sizeOfFileOnDiskInBytes() {
            return this.rocksDB.getTotalBytesWritten();
        }
    }
}

