/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.util.HashMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.utils.map.SimpleMap;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class StructLikeMemoryMap<T>
extends StructLikeBaseMap<T> {
    private final SimpleMap<StructLikeWrapper, T> wrapperMap = new SimpleMemoryMap();

    public static <T> StructLikeMemoryMap<T> create(Types.StructType type) {
        return new StructLikeMemoryMap<T>(type);
    }

    private StructLikeMemoryMap(Types.StructType type) {
        super(type);
    }

    @Override
    protected SimpleMap<StructLikeWrapper, T> getInternalMap() {
        return this.wrapperMap;
    }

    private static class SimpleMemoryMap<T>
    implements SimpleMap<StructLikeWrapper, T> {
        HashMap<StructLikeWrapper, T> map = Maps.newHashMap();

        private SimpleMemoryMap() {
        }

        @Override
        public void put(StructLikeWrapper key, T value) {
            this.map.put(key, value);
        }

        @Override
        public void delete(StructLikeWrapper key) {
            this.map.remove(key);
        }

        @Override
        public T get(StructLikeWrapper key) {
            return this.map.get(key);
        }

        @Override
        public void close() {
        }
    }
}

