/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLocate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(substr, str[, pos]) - Returns the position of the first occurrence of `substr` in `str` after position `pos`.\n      The given `pos` and return value are 1-based.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('bar', 'foobarbar');\n       4\n      > SELECT _FUNC_('bar', 'foobarbar', 5);\n       7\n      > SELECT POSITION('bar' IN 'foobarbar');\n       4\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0013&\u0001JB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011!Y\u0005A!f\u0001\n\u0003!\u0005\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011B#\t\u000b5\u0003A\u0011\u0001(\t\u000b5\u0003A\u0011A*\t\u000bY\u0003A\u0011\t#\t\u000b]\u0003A\u0011\t#\t\u000ba\u0003A\u0011\t#\t\u000be\u0003A\u0011\t.\t\u000by\u0003A\u0011I0\t\u000b\u0019\u0004A\u0011I4\t\u000bQ\u0004A\u0011I;\t\r}\u0004A\u0011KA\u0001\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\r\u0001\t#\n\u0019\u0004C\u0005\u0002B\u0001\t\t\u0011\"\u0001\u0002D!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u001a\u0001#\u0003%\t!!\u0014\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\u0019\tAA\u0001\n\u0003\t)\tC\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003C\u0003\u0011\u0011!C!\u0003G;\u0011\"a2&\u0003\u0003E\t!!3\u0007\u0011\u0011*\u0013\u0011!E\u0001\u0003\u0017Da!\u0014\u0010\u0005\u0002\u0005e\u0007\"CAn=\u0005\u0005IQIAo\u0011%\tyNHA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002jz\t\t\u0011\"!\u0002l\"I\u0011Q \u0010\u0002\u0002\u0013%\u0011q \u0002\r'R\u0014\u0018N\\4M_\u000e\fG/\u001a\u0006\u0003M\u001d\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001&K\u0001\tG\u0006$\u0018\r\\=ti*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M)\u0001aM\u001c;\u0001B\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001b9\u0013\tITE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0001&o\u001c3vGR\u0004\"aO!\n\u0005\tc$\u0001D*fe&\fG.\u001b>bE2,\u0017AB:vEN$(/F\u0001F!\t!d)\u0003\u0002HK\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000fM,(m\u001d;sA\u0005\u00191\u000f\u001e:\u0002\tM$(\u000fI\u0001\u0006gR\f'\u000f^\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\rqJg.\u001b;?)\u0011y\u0005+\u0015*\u0011\u0005Q\u0002\u0001\"B\"\b\u0001\u0004)\u0005\"B%\b\u0001\u0004)\u0005\"B&\b\u0001\u0004)EcA(U+\")1\t\u0003a\u0001\u000b\")\u0011\n\u0003a\u0001\u000b\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u00027B\u00111\bX\u0005\u0003;r\u0012qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2*\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002QB\u0019\u0011.\u001d1\u000f\u0005)|gBA6o\u001b\u0005a'BA72\u0003\u0019a$o\\8u}%\tQ(\u0003\u0002qy\u00059\u0001/Y2lC\u001e,\u0017B\u0001:t\u0005\r\u0019V-\u001d\u0006\u0003ar\nA!\u001a<bYR\u0011a/\u001f\t\u0003w]L!\u0001\u001f\u001f\u0003\u0007\u0005s\u0017\u0010C\u0004{\u001fA\u0005\t\u0019A>\u0002\u000b%t\u0007/\u001e;\u0011\u0005qlX\"A\u0014\n\u0005y<#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\r\u0011qBA\r!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005K\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0007\u0003\u000f\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003#\u0001\u0002\u0019AA\n\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000b\t)\"\u0003\u0003\u0002\u0018\u0005\u001d!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u00037\u0001\u0002\u0019AA\u0002\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\t\u0011\t\u0005\r\u00121\u0006\b\u0005\u0003K\t9\u0003\u0005\u0002ly%\u0019\u0011\u0011\u0006\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#a\f\u0003\rM#(/\u001b8h\u0015\r\tI\u0003P\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$raTA\u001b\u0003s\ti\u0004\u0003\u0004\u00028I\u0001\r!R\u0001\t]\u0016<h)\u001b:ti\"1\u00111\b\nA\u0002\u0015\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005}\"\u00031\u0001F\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$raTA#\u0003\u000f\nI\u0005C\u0004D'A\u0005\t\u0019A#\t\u000f%\u001b\u0002\u0013!a\u0001\u000b\"91j\u0005I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fR3!RA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA/y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0014\u0001\u00026bm\u0006LA!!\f\u0002p\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0010\t\u0004w\u0005}\u0014bAAAy\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a/a\"\t\u0013\u0005%\u0015$!AA\u0002\u0005u\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0010B)\u0011\u0011SALm6\u0011\u00111\u0013\u0006\u0004\u0003+c\u0014AC2pY2,7\r^5p]&!\u0011\u0011TAJ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007m\u000by\n\u0003\u0005\u0002\nn\t\t\u00111\u0001w\u0003\u0019)\u0017/^1mgR\u00191,!*\t\u0011\u0005%E$!AA\u0002YD3\u0003AAU\u0003_\u000b\t,!.\u00028\u0006m\u0016QXAa\u0003\u0007\u00042\u0001NAV\u0013\r\ti+\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019,AA1\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:vEN$(\u000f\f\u0011tiJ\\F\u0006\t9pgvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI8dGV\u0014(/\u001a8dK\u0002zg\r\t1tk\n\u001cHO\u001d1!S:\u0004\u0003m\u001d;sA\u0002\ng\r^3sAA|7/\u001b;j_:\u0004\u0003\r]8tA:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011hSZ,g\u000e\t1q_N\u0004\u0007%\u00198eAI,G/\u001e:oAY\fG.^3!CJ,\u0007%M\u0017cCN,GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002:\u0006\tIG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(E\u0006\u0014x\u0005\f\u0011(M>|'-\u0019:cCJ<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#-\u0019:(Y\u0001:cm\\8cCJ\u0014\u0017M]\u0014-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAA{5+\u0013+J\u001f:CsEY1sO\u0001Je\nI\u0014g_>\u0014\u0017M\u001d2be\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b\u000bA\u0001\nQa]5oG\u0016\f#!a0\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0015\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&tw\rT8dCR,\u0007C\u0001\u001b\u001f'\u0011q\u0012Q\u001a!\u0011\u0011\u0005=\u0017Q[#F\u000b>k!!!5\u000b\u0007\u0005MG(A\u0004sk:$\u0018.\\3\n\t\u0005]\u0017\u0011\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAe\u0003!!xn\u0015;sS:<GCAA6\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy\u00151]As\u0003ODQaQ\u0011A\u0002\u0015CQ!S\u0011A\u0002\u0015CQaS\u0011A\u0002\u0015\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002n\u0006e\b#B\u001e\u0002p\u0006M\u0018bAAyy\t1q\n\u001d;j_:\u0004baOA{\u000b\u0016+\u0015bAA|y\t1A+\u001e9mKNB\u0001\"a?#\u0003\u0003\u0005\raT\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0001\u0011\t\u00055$1A\u0005\u0005\u0005\u000b\tyG\u0001\u0004PE*,7\r\u001e")
public class StringLocate
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression substr;
    private final Expression str;
    private final Expression start;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLocate stringLocate) {
        return StringLocate$.MODULE$.unapply(stringLocate);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLocate> tupled() {
        return StringLocate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLocate>>> curried() {
        return StringLocate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression substr() {
        return this.substr;
    }

    public Expression str() {
        return this.str;
    }

    public Expression start() {
        return this.start;
    }

    @Override
    public Expression first() {
        return this.substr();
    }

    @Override
    public Expression second() {
        return this.str();
    }

    @Override
    public Expression third() {
        return this.start();
    }

    @Override
    public boolean nullable() {
        return this.substr().nullable() || this.str().nullable();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Object eval(InternalRow input) {
        int sVal;
        Object l;
        Object r;
        Object s = this.start().eval(input);
        return s == null ? BoxesRunTime.boxToInteger((int)0) : ((r = this.substr().eval(input)) == null ? null : ((l = this.str().eval(input)) == null ? null : ((sVal = BoxesRunTime.unboxToInt((Object)s)) < 1 ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)(((UTF8String)l).indexOf((UTF8String)r, BoxesRunTime.unboxToInt((Object)s) - 1) + 1)))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode substrGen = this.substr().genCode(ctx);
        ExprCode strGen = this.str().genCode(ctx);
        ExprCode startGen = this.start().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      int ", " = 0;\n      boolean ", " = false;\n      ", "\n      if (!", ") {\n        ", "\n        if (!", ") {\n          ", "\n          if (!", ") {\n            if (", " > 0) {\n              ", " = ", ".indexOf(", ",\n                ", " - 1) + 1;\n            }\n          } else {\n            ", " = true;\n          }\n        } else {\n          ", " = true;\n        }\n      }\n     "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ev.isNull(), startGen.code(), startGen.isNull(), substrGen.code(), substrGen.isNull(), strGen.code(), strGen.isNull(), startGen.value(), ev.value(), strGen.value(), substrGen.value(), startGen.value(), ev.isNull(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "locate");
    }

    @Override
    public StringLocate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringLocate copy(Expression substr, Expression str, Expression start) {
        return new StringLocate(substr, str, start);
    }

    public Expression copy$default$1() {
        return this.substr();
    }

    public Expression copy$default$2() {
        return this.str();
    }

    public Expression copy$default$3() {
        return this.start();
    }

    @Override
    public String productPrefix() {
        return "StringLocate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.substr();
                break;
            }
            case 1: {
                expression = this.str();
                break;
            }
            case 2: {
                expression = this.start();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLocate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLocate)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLocate stringLocate = (StringLocate)x$1;
        Expression expression = this.substr();
        Expression expression2 = stringLocate.substr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.str();
        Expression expression4 = stringLocate.str();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.start();
        Expression expression6 = stringLocate.start();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLocate.canEqual(this)) return false;
        return true;
    }

    public StringLocate(Expression substr, Expression str, Expression start) {
        this.substr = substr;
        this.str = str;
        this.start = start;
        ExpectsInputTypes.$init$(this);
    }

    public StringLocate(Expression substr, Expression str) {
        this(substr, str, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

