/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMasterClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;

public class TieredInternalShuffleMaster {
    private final TieredStorageMasterClient tieredStorageMasterClient;
    private final ShuffleMasterContext shuffleMasterContext;

    public TieredInternalShuffleMaster(ShuffleMasterContext shuffleMasterContext) {
        this.shuffleMasterContext = shuffleMasterContext;
        Configuration conf = shuffleMasterContext.getConfiguration();
        TieredStorageConfiguration tieredStorageConfiguration = TieredStorageConfiguration.fromConfiguration(conf);
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        List<TierMasterAgent> tierFactories = tieredStorageConfiguration.getTierFactories().stream().map(tierFactory -> tierFactory.createMasterAgent(resourceRegistry)).collect(Collectors.toList());
        this.tieredStorageMasterClient = new TieredStorageMasterClient(tierFactories);
    }

    public void registerJob(JobShuffleContext context) {
        this.tieredStorageMasterClient.registerJob(context.getJobId(), this.getTierShuffleHandler(context));
    }

    public void unregisterJob(JobID jobID) {
        this.tieredStorageMasterClient.unregisterJob(jobID);
    }

    public List<TierShuffleDescriptor> addPartitionAndGetShuffleDescriptor(JobID jobID, ResultPartitionID resultPartitionID) {
        return this.tieredStorageMasterClient.addPartitionAndGetShuffleDescriptor(jobID, resultPartitionID);
    }

    public void releasePartition(ShuffleDescriptor shuffleDescriptor) {
        this.tieredStorageMasterClient.releasePartition(shuffleDescriptor);
    }

    public void close() {
        this.tieredStorageMasterClient.close();
    }

    private TierShuffleHandler getTierShuffleHandler(final JobShuffleContext context) {
        return new TierShuffleHandler(){

            @Override
            public CompletableFuture<?> onReleasePartitions(Collection<TieredStoragePartitionId> partitionIds) {
                return context.stopTrackingAndReleasePartitions(partitionIds.stream().map(TieredStorageIdMappingUtils::convertId).collect(Collectors.toList()));
            }

            @Override
            public void onFatalError(Throwable throwable) {
                TieredInternalShuffleMaster.this.shuffleMasterContext.onFatalError(throwable);
            }
        };
    }
}

