/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blocklist.BlockedTaskManagerChecker;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocator;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceEventListener;
import org.apache.flink.runtime.rest.messages.taskmanager.SlotInfo;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.SlotReport;

public interface SlotManager
extends AutoCloseable {
    public int getNumberRegisteredSlots();

    public int getNumberRegisteredSlotsOf(InstanceID var1);

    public int getNumberFreeSlots();

    public int getNumberFreeSlotsOf(InstanceID var1);

    public ResourceProfile getRegisteredResource();

    public ResourceProfile getRegisteredResourceOf(InstanceID var1);

    public ResourceProfile getFreeResource();

    public ResourceProfile getFreeResourceOf(InstanceID var1);

    public Collection<SlotInfo> getAllocatedSlotsOf(InstanceID var1);

    public void start(ResourceManagerId var1, Executor var2, ResourceAllocator var3, ResourceEventListener var4, BlockedTaskManagerChecker var5);

    public void suspend();

    public void clearResourceRequirements(JobID var1);

    public void processResourceRequirements(ResourceRequirements var1);

    public RegistrationResult registerTaskManager(TaskExecutorConnection var1, SlotReport var2, ResourceProfile var3, ResourceProfile var4);

    public boolean unregisterTaskManager(InstanceID var1, Exception var2);

    public boolean reportSlotStatus(InstanceID var1, SlotReport var2);

    public void freeSlot(SlotID var1, AllocationID var2);

    public void setFailUnfulfillableRequest(boolean var1);

    public void triggerResourceRequirementsCheck();

    public static enum RegistrationResult {
        SUCCESS,
        IGNORED,
        REJECTED;

    }
}

